% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lyl_plot.R
\name{lyl_2plot}
\alias{lyl_2plot}
\title{Plot Life Years Lost at one specific age for two different populations}
\usage{
lyl_2plot(
  x,
  y,
  color_alive = NA,
  colors = NA,
  labels = c("Population of interest", "Reference population"),
  ...
)
}
\arguments{
\item{x}{An object of class \code{lyl} (obtained with function \code{lyl}).}

\item{y}{An object of class \code{lyl} (obtained with function \code{lyl}).}

\item{color_alive}{Color to be used for the censoring category. Default is NA, and
default color is "white".}

\item{colors}{Vector with one color for each cause of death. Default is NA, and
default colors are used.}

\item{labels}{Vector with labels for the two populations (default are "Population of
interest" for \code{x}, and "Reference population" for \code{y})}

\item{...}{Additional arguments affecting the plot produced.}
}
\value{
A plot with survival function and stacked cause-specific cumulative incidences for two
populations side by side.
}
\description{
\code{lyl_2plot} was used to create a figure of Life Years Lost
at one specific age for two different populations. Please use
\code{lyl_compare_plot} instead.
}
\examples{
# Load simulated data as example
data(simu_data)

# Estimate remaining life expectancy and Life Years
# Lost after age 45 years and before age 95 years
lyl_estimation <- lyl(data = simu_data, t = age_death, status = cause_death,
                      age_specific = 45, tau = 95)

# Same estimate for those with a specific disease
diseased <- simu_data[!is.na(simu_data$age_disease), ]

lyl_estimation1 <- lyl(data = diseased, t0 = age_disease,
                       t = age_death, status = cause_death,
                      age_specific = 45, tau = 95)

# Plot the data
lyl_compare_plot(list(lyl_estimation1, lyl_estimation))
}
\references{
\itemize{
    \item{Plana-Ripoll et al. lillies – An R package for the estimation of excess Life Years Lost among patients with a given disease or condition.
    \emph{PLoS ONE}. 2020;15(3):e0228073.}
}
}
\seealso{
\itemize{
    \item{\code{\link{lyl}} for estimation of Life Years Lost at one specific age.}
    \item{\code{\link{lyl_diff}} to compare Life Years Lost for two populations.}
}
}
