% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lyl_diff_ref.R
\name{lyl_diff_ref}
\alias{lyl_diff_ref}
\title{Summarize differences in Life Years Lost.}
\usage{
lyl_diff_ref(
  lyl_population1,
  data_ref,
  age,
  surv,
  rates,
  decimals = 2,
  level = 0.95,
  weights = NA,
  lyl_population0
)
}
\arguments{
\item{lyl_population1}{Population of interest: An object of class \code{lyl} or \code{lyl_range} (obtained with
functions \code{lyl} or \code{lyl_range}). Alternatively, an object of class \code{lyl_ci} can be provided for
bootstrapped confidence intervals.}

\item{data_ref}{A dataframe, where each raw represents an age, for the population of
reference The dataframe will contain information on age-specific mortality rates
or survivial probability (if both parameters are provided, rates will be used).}

\item{age}{Variable in \code{data_ref} containing information on age.}

\item{surv}{Variable in \code{data_ref} containing information on age-specific survival probability.}

\item{rates}{Variable in \code{data_ref} containing information on age-specific mortality rates.}

\item{decimals}{Number of decimals to be reported (default is 2).}

\item{level}{Confidence level if \code{lyl_population1} or \code{lyl_population0} is obtained with the \code{lyl_ci}
function (default is 0.95 for 95\% confidence intervals)}

\item{weights}{Vector with age distribution of disease/condition onset to be used when Life Years Lost are estimated
over a range of ages (with \code{lyl_range} function). If weights are not provided (dafault is \code{weights = NA}),
then the differences in Life Years Lost at each age is provided. If weights are provided, then a weighted average is provided.}

\item{lyl_population0}{Parameter automatically created.}
}
\value{
A table with the summary of the differences between two populations.
}
\description{
\code{lyl_diff} summarizes differences in estimated Life Years Lost
in two different populations: \code{lyl_estimation1} compared to a life table provided in \code{data_ref}.
}
\examples{
# Load simulated data as example
data(simu_data)
data(pop_ref)

# Estimate remaining life expectancy and Life Years
# Lost due to specific causes of death after age 45
# years and before age 95 years for those with a disease
diseased <- simu_data[!is.na(simu_data$age_disease), ]
lyl_estimation1 <- lyl(data = diseased, t0 = age_disease,
                       t = age_death, status = cause_death,
                       age_specific = 45, tau = 95)
lyl_diff_ref(lyl_estimation1, pop_ref, age = age, surv = survival)
lyl_diff_ref(lyl_estimation1, pop_ref, age = age, rates = mortality_rates)

# Calculate bootstrapped confidence interval (3 iterations to test; more are necessary)
lyl_estimation1_ci <- lyl_ci(lyl_estimation1, niter = 3)
lyl_diff_ref(lyl_estimation1_ci, pop_ref, age = age, surv = survival)

\donttest{
# Estimate remaining life expectancy and Life Years
# Lost due to specific causes of death after each age
# from 0 to 94 years and before age 95 years
lyl_estimation2 <- lyl_range(data = diseased, t0 = age_disease,
                             t = age_death, status = cause_death,
                             age_begin = 0, age_end = 94, tau = 95)
lyl_diff_ref(lyl_estimation2, pop_ref, age = age, surv = survival)
lyl_diff_ref(lyl_estimation2, pop_ref, age = age, surv = survival, weights = diseased$age_disease)
}

}
\references{
\itemize{
    \item{Plana-Ripoll et al. lillies – An R package for the estimation of excess Life Years Lost among patients with a given disease or condition.
    \emph{PLoS ONE}. 2020;15(3):e0228073.}
}
}
\seealso{
\itemize{
    \item{\code{\link{lyl}} for estimation of Life Years Lost at one specific age.}
    \item{\code{\link{lyl_range}} for estimation of Life Years Lost for a range of different ages.}
}
}
