% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solve.R
\name{solve_board}
\alias{solve_board}
\title{Solve a Lights Out board}
\usage{
solve_board(board)
}
\arguments{
\item{board}{A \code{lightsout} board object.}
}
\value{
A matrix with the same dimensions as the input board, with a \code{1}
in every position that requires a press to solve to the board. Note that the
order of the light presses does not matter.
}
\description{
Given a Lights Out board, find the set of lights that need to be pressed in
order to solve the board. If no solution is possible, an error is thrown.
}
\details{
There are a few algorithms for solving Lights Out puzzles. This function
implements the Gaussian Elimination technique, which does not guarantee
the minimum number of steps. Therefore, some steps in the given solution
may be redundant.

If you are interested, there are many resources online outlining the exact
details of how this technique works, and what the other solving strategies are.
}
\examples{
# Create an empty 5x5 board, press two lights, and then see that the solution
# tells us to press the same lights in order to solve the board.
board <- empty_board(5) \%>\% play(3, 2) \%>\% play(4, 1)
board
solution <- solve_board(board)
solution
board <- play(board, matrix = solution)
is_solved(board)
}
\seealso{
\code{\link[lightsout]{new_board}}
\code{\link[lightsout]{random_board}}
\code{\link[lightsout]{play}}
\code{\link[lightsout]{is_solvable}}
\code{\link[lightsout]{is_solved}}
}
