% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aba.R
\name{BoxcoxTr}
\alias{BoxcoxTr}
\title{Box-Cox Transformation}
\usage{
BoxcoxTr(x, lambda)
}
\arguments{
\item{x}{vector or RasterLayer. values to be transformed}

\item{lambda}{numeric. parameter of Box-Cox transformation}
}
\value{
a vector or RasterLayer of transformed values
}
\description{
Box-Cox Transformation
}
\examples{
x <- 1:10
BoxcoxTr(x, -2)
BoxcoxTr(x, 0)
BoxcoxTr(x, 0.5)
BoxcoxTr(x, 2)

# plot functions
curve(BoxcoxTr(x, 1.5), 1, 5, main = "Box Cox transform", xlab = "x",
ylab = "Boxcox(x, lambda)", col = "red")
curve(BoxcoxTr(x, -2), 1, 5, col = "green", add = TRUE)
curve(BoxcoxTr(x, 0), 1, 5, col = "blue", add = TRUE)
curve(BoxcoxTr(x, 0.5), 1, 5,  col = "black", add = TRUE)
curve(BoxcoxTr(x, 1), 1, 5, col = "pink", add = TRUE)
legend("topleft", legend = rev(c(-2, 0, 0.5, 1, 1.5, "lambda")),
col = rev(c("green", "blue", "black", "pink", "red", NA)), lty = 1)
}
\seealso{
\code{\link{iBoxcoxTr}} inverse Box-Cox transformation, \code{\link{iBoxcoxTrBiasCor}} inverse Box-Cox transformation with bias correction.
}
