% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/libname.R
\name{lib_write}
\alias{lib_write}
\title{Write a Data Library to the File System}
\usage{
lib_write(x, force = FALSE)
}
\arguments{
\item{x}{The data library to write.}

\item{force}{Force writing each data file to disk, even if it has not 
changed.}
}
\value{
The saved data library.
}
\description{
The \code{lib_write} function writes the data library
to the file system.  The library will be written to the 
directory for which it was defined, and each data frame will be written
in the format associated with the library data engine.  See the 
\code{\link{libname}} function for further elaboration on the types
of engines available, and the assumptions/limitations of each.  

By default, the \code{lib_write} function will not write data that has 
not changed.  Prior to writing a file, \code{lib_write} will compare the 
data in memory to the data on disk.  If there are differences in the data,
the function will overwrite the version on disk.  To override the default
behavior, use the \code{force} option to force \code{lib_write} to write
every data file to disk.
}
\examples{
# Create temp directory
tmp <- tempdir()

# Create library
libname(dat, tmp)
# # library 'dat': 0 items
# - attributes: rds not loaded
# - path: C:\Users\User\AppData\Local\Temp\RtmpCSJ6Gc
# NULL

# Load the empty library 
lib_load(dat)

# Add data to the library
dat.mtcars <- mtcars
dat.beaver1 <- beaver1
dat.iris <- iris

# Unload the library
lib_unload(dat)
# library 'dat': 3 items
# - attributes: rds not loaded
# - path: C:\Users\User\AppData\Local\Temp\RtmpCSJ6Gc
# - items:
#      Name Extension Rows Cols   Size LastModified
# 1 beaver1        NA  114    4 4.6 Kb         <NA>
# 2    iris        NA  150    5 7.1 Kb         <NA>
# 3  mtcars        NA   32   11   7 Kb         <NA>

# Write the library to the file system
lib_write(dat)
# library 'dat': 3 items
#- attributes: not loaded
#- path: C:\Users\User\AppData\Local\Temp\RtmpCSJ6Gc
#- items:
#     Name Extension Rows Cols   Size        LastModified
#1 beaver1       rds  114    4 4.8 Kb 2020-11-05 20:47:16
#2    iris       rds  150    5 7.3 Kb 2020-11-05 20:47:16
#3  mtcars       rds   32   11 7.3 Kb 2020-11-05 20:47:16

# Clean up
lib_delete(dat)
}
\seealso{
Other lib: 
\code{\link{is.lib}()},
\code{\link{lib_add}()},
\code{\link{lib_copy}()},
\code{\link{lib_delete}()},
\code{\link{lib_info}()},
\code{\link{lib_load}()},
\code{\link{lib_path}()},
\code{\link{lib_remove}()},
\code{\link{lib_replace}()},
\code{\link{lib_size}()},
\code{\link{lib_sync}()},
\code{\link{lib_unload}()},
\code{\link{libname}()},
\code{\link{print.lib}()}
}
\concept{lib}
