% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{deflate_decompress}
\alias{deflate_decompress}
\title{Decompress a raw vector with libdeflate}
\usage{
deflate_decompress(decompressor, input, out_len)
}
\arguments{
\item{decompressor}{An external pointer created by `alloc_decompressor()`.}

\item{input}{A raw vector containing the compressed DEFLATE stream.}

\item{out_len}{Integer giving the expected uncompressed length (in bytes).}
}
\value{
A raw vector of length `out_len` containing the decompressed data.
}
\description{
Decompress a raw DEFLATE stream to its original length.
}
\examples{
# round-trip example
msg = "Round-trip test: 123123123123"
raw_in = charToRaw(msg)
cmp = alloc_compressor(12L)
raw_cmp = deflate_compress(cmp, raw_in)
dcmp = alloc_decompressor()
raw_out = deflate_decompress(dcmp, raw_cmp, length(raw_in))
stopifnot(identical(raw_out, raw_in))
}
