% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Logger.R
\name{LoggerGlue}
\alias{LoggerGlue}
\title{LoggerGlue}
\description{
\code{LoggerGlue} uses \code{\link[glue:glue]{glue::glue()}} instead of \code{\link[base:sprintf]{base::sprintf()}} to construct
log messages. \strong{glue} is a very well designed package for
string interpolation. It makes composing log messages
more flexible and comfortable at the price of an additional dependency and
slightly less performance than \code{sprintf()}.
}
\details{
\code{glue()} lets you define temporary named variables inside the call.
As with the normal Logger, these named arguments get turned into custom
fields; however, you can suppress this behaviour by making named argument
start with a \code{"."}. Please refer to \code{vignette("lgr", package = "lgr")} for
examples.
}
\section{Super classes}{
\code{\link[lgr:Filterable]{lgr::Filterable}} -> \code{\link[lgr:Logger]{lgr::Logger}} -> \code{LoggerGlue}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-fatal}{\code{LoggerGlue$fatal()}}
\item \href{#method-error}{\code{LoggerGlue$error()}}
\item \href{#method-warn}{\code{LoggerGlue$warn()}}
\item \href{#method-info}{\code{LoggerGlue$info()}}
\item \href{#method-debug}{\code{LoggerGlue$debug()}}
\item \href{#method-trace}{\code{LoggerGlue$trace()}}
\item \href{#method-log}{\code{LoggerGlue$log()}}
\item \href{#method-list_log}{\code{LoggerGlue$list_log()}}
\item \href{#method-spawn}{\code{LoggerGlue$spawn()}}
}
}
\if{html}{
\out{<details ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="add_filter">}\href{../../lgr/html/Filterable.html#method-add_filter}{\code{lgr::Filterable$add_filter()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="filter">}\href{../../lgr/html/Filterable.html#method-filter}{\code{lgr::Filterable$filter()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="remove_filter">}\href{../../lgr/html/Filterable.html#method-remove_filter}{\code{lgr::Filterable$remove_filter()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Filterable" data-id="set_filters">}\href{../../lgr/html/Filterable.html#method-set_filters}{\code{lgr::Filterable$set_filters()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Logger" data-id="add_appender">}\href{../../lgr/html/Logger.html#method-add_appender}{\code{lgr::Logger$add_appender()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Logger" data-id="config">}\href{../../lgr/html/Logger.html#method-config}{\code{lgr::Logger$config()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Logger" data-id="handle_exception">}\href{../../lgr/html/Logger.html#method-handle_exception}{\code{lgr::Logger$handle_exception()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Logger" data-id="initialize">}\href{../../lgr/html/Logger.html#method-initialize}{\code{lgr::Logger$initialize()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Logger" data-id="remove_appender">}\href{../../lgr/html/Logger.html#method-remove_appender}{\code{lgr::Logger$remove_appender()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Logger" data-id="set_appenders">}\href{../../lgr/html/Logger.html#method-set_appenders}{\code{lgr::Logger$set_appenders()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Logger" data-id="set_exception_handler">}\href{../../lgr/html/Logger.html#method-set_exception_handler}{\code{lgr::Logger$set_exception_handler()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Logger" data-id="set_propagate">}\href{../../lgr/html/Logger.html#method-set_propagate}{\code{lgr::Logger$set_propagate()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="lgr" data-topic="Logger" data-id="set_threshold">}\href{../../lgr/html/Logger.html#method-set_threshold}{\code{lgr::Logger$set_threshold()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fatal"></a>}}
\if{latex}{\out{\hypertarget{method-fatal}{}}}
\subsection{Method \code{fatal()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LoggerGlue$fatal(..., caller = get_caller(-8L), .envir = parent.frame())}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-error"></a>}}
\if{latex}{\out{\hypertarget{method-error}{}}}
\subsection{Method \code{error()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LoggerGlue$error(..., caller = get_caller(-8L), .envir = parent.frame())}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-warn"></a>}}
\if{latex}{\out{\hypertarget{method-warn}{}}}
\subsection{Method \code{warn()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LoggerGlue$warn(..., caller = get_caller(-8L), .envir = parent.frame())}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-info"></a>}}
\if{latex}{\out{\hypertarget{method-info}{}}}
\subsection{Method \code{info()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LoggerGlue$info(..., caller = get_caller(-8L), .envir = parent.frame())}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-debug"></a>}}
\if{latex}{\out{\hypertarget{method-debug}{}}}
\subsection{Method \code{debug()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LoggerGlue$debug(..., caller = get_caller(-8L), .envir = parent.frame())}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-trace"></a>}}
\if{latex}{\out{\hypertarget{method-trace}{}}}
\subsection{Method \code{trace()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LoggerGlue$trace(..., caller = get_caller(-8L), .envir = parent.frame())}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-log"></a>}}
\if{latex}{\out{\hypertarget{method-log}{}}}
\subsection{Method \code{log()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LoggerGlue$log(
  level,
  ...,
  timestamp = Sys.time(),
  caller = get_caller(-7),
  .envir = parent.frame()
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-list_log"></a>}}
\if{latex}{\out{\hypertarget{method-list_log}{}}}
\subsection{Method \code{list_log()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LoggerGlue$list_log(x)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-spawn"></a>}}
\if{latex}{\out{\hypertarget{method-spawn}{}}}
\subsection{Method \code{spawn()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{LoggerGlue$spawn(name)}\if{html}{\out{</div>}}
}

}
}
