% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Appender.R
\name{AppenderSyslog}
\alias{AppenderSyslog}
\title{Log to the POSIX System Log}
\description{
An Appender that writes to the syslog on supported POSIX platforms. Requires
the \pkg{rsyslog} package.
}
\section{Usage}{
\preformatted{
x <- AppenderSyslog$new(identifier = NULL, threshold = NA_integer_, layout =
  LayoutFormat$new("\%m"), filters = NULL, syslog_levels = c(CRITICAL = "fatal",
  ERR = "error", WARNING = "warn", INFO = "info", DEBUG = "debug", DEBUG =
  "trace"))

x$add_filter(filter, name = NULL)
x$append(event)
x$filter(event)
x$format(color = FALSE, ...)
x$remove_filter(pos)
x$set_filters(filters)
x$set_identifier(x)
x$set_layout(layout)
x$set_syslog_levels(x)
x$set_threshold(level)

x$destination
x$filters
x$identifier
x$layout
x$syslog_levels
x$threshold

}
}

\section{Fields}{


\describe{
\item{\code{identifier}}{\code{character} scalar. A string identifying the process;
if \code{NULL} defaults to the logger name}
\item{\code{syslog_levels}}{
\itemize{
\item a named \code{character} vector mapping whose names are log levels as
understood by \code{\link[rsyslog:syslog]{rsyslog::syslog()}} and whose values are
\link[=log_levels]{lgr log levels} (either \code{character} or \code{numeric})
\item a \code{function} that takes a vector of lgr log levels as input and returns a
\code{character} vector of log levels for \code{\link[rsyslog:syslog]{rsyslog::syslog()}}.
}
}
}



\describe{
\item{\code{threshold}, \code{set_threshold(level)}}{\code{character} or \code{integer} scalar.
The minimum log level that triggers this logger. See \link{log_levels}}
\item{\code{layout}, \code{set_layout(layout)}}{a \code{Layout} that will be used for
formatting the \code{LogEvents} passed to this Appender}
\item{\code{destination}}{The output destination of the \code{Appender} in
human-readable form (mainly for print output)}
}



\describe{
\item{\code{filters}, \code{set_filters(filters)}}{a \code{list} that may contain
\code{functions} or any \R object with a \code{filter()} method. These functions
must have exactly one argument: \code{event} which will get passed the
LogEvent when the Filterable's \code{filter()} method is invoked.
If all of these functions evaluate to \code{TRUE} the LogEvent is passed on.
Since LogEvents have reference semantics, filters can also be abused to
modify them before they are passed on. Look at the source code of
\code{\link[=with_log_level]{with_log_level()}} or \code{\link[=with_log_value]{with_log_value()}} for examples.
}
}
}

\section{Creating a New Appender}{


New Appenders are instantiated with \code{<AppenderSubclass>$new()}. For the
arguments to \code{new()} please refer to the section \emph{Fields}. You can also
modify those fields after the Appender has been created with setters in the
form of \code{appender$set_<fieldname>(value)}
}

\section{Methods}{

\describe{
\item{\code{append(event)}}{Tell the Appender to process a \link{LogEvent} \code{event}.
This method is usually not called by the user, but invoked by a
\link{Logger}
}
}


\describe{
\item{\code{filter(event)}}{Determine whether the LogEvent \code{x} should be passed
on to Appenders (\code{TRUE}) or not (\code{FALSE}). See also the active binding
\code{filters}}
\item{\code{add_filter(filter, name = NULL)}, \code{remove_filter(pos)}}{
Add or remove a filter. When adding a filter an optional \code{name} can
be specified. \code{remove_filter()} can remove by position or name (if one
was specified)
}
}
}

\examples{
if (requireNamespace("rsyslog", quietly = TRUE)) {
  lg <- get_logger("rsyslog/test")
  lg$add_appender(AppenderSyslog$new(), "syslog")
  lg$info("A test message")

  if (Sys.info()[["sysname"]] == "Linux"){
    system("journalctl -t 'rsyslog/test'")
  }

  invisible(lg$config(NULL))  # cleanup
}
}
\seealso{
\link{LayoutFormat}, \link{LayoutJson}

Other Appenders: \code{\link{AppenderBuffer}},
  \code{\link{AppenderConsole}}, \code{\link{AppenderDbi}},
  \code{\link{AppenderFileRotating}},
  \code{\link{AppenderFile}}, \code{\link{AppenderGmail}},
  \code{\link{AppenderJson}},
  \code{\link{AppenderPushbullet}},
  \code{\link{AppenderRjdbc}},
  \code{\link{AppenderSendmail}},
  \code{\link{AppenderTable}}, \code{\link{Appender}}
}
\concept{Appenders}
