% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/minimumContrast.R
\name{C.diff.single.im}
\alias{C.diff.single.im}
\title{C.diff.single.im function}
\usage{
C.diff.single.im(theta, data, ps, Chat, vseq, spat, model)
}
\arguments{
\item{theta}{Single numeric value for the parameter controlling the scale of temporal dependence in the frequency of observations.}

\item{data}{Object of class stppp, giving the observed spatiotemporal data set.}

\item{ps}{A numeric vector of length 2 giving fixed values of phi and sigma^2, in that order.}

\item{Chat}{A numeric vector giving the nonparametric estimate of the temporal autocorrelation function at all temporal lags specified by vseq.}

\item{vseq}{An increasing, equally spaced numeric vector giving the temporal distances at which the contrast criterion is to be evaluated.}

\item{spat}{A density estimate of the fixed, possibly inhomogeneous, density of the underlying spatial trend. An object of class 'im' (spatstat). May be unnormalised; in which case it will be scaled to integrate to 1 over the spatial study region.}

\item{model}{A character string specifying the form of the theoretical spatial correlation function (matches 'model' argument for CovarianceFct in the RandomFields packages).}
}
\value{
A single numeric value providing the minimum contrast value for the specified value of the theta argument.
}
\description{
A function to find the minimum contrast (squared discrepancy) value based on the the temporal autocorrelation function, for one specific value of theta (temporal scale) for the spatiotemporal LGCP.
Only the exponential form is considered for the theoretical temporal correlation function. This also depends upon a static pair of values for the spatial scale and spatial variance of the latent Gaussian process (usually estimated first).
}
