% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lets_classvar.R
\name{lets.classvar}
\alias{lets.classvar}
\title{Frequency distribution of a variable within a species' range}
\usage{
lets.classvar(x, groups = "default", pos, xy)
}
\arguments{
\item{x}{Presence-absence \code{matrix} with a single variable 
added (see \code{\link{lets.addvar}}).}

\item{groups}{The number of classes into which the variable will be divided. 
Default calculates the number of classes as the 
default for a histogram (\code{\link{hist}}).}

\item{pos}{Column number containing the variable of interest.}

\item{xy}{Logical, if \code{TRUE} the input matrix contains the geographic 
coordinates in the first two columns.}
}
\value{
A \code{matrix} with species in the rows and the variable's 
classes in the columns.
}
\description{
Based on a species Presence-Absence matrix including
 variables of interest (see \code{\link{lets.addvar}}), the 
 function divides a continuous variable into classes and counts 
 the frequency of each class within each species' range.
}
\examples{
\dontrun{
data(PAM)
data(temp)
pamvar <- lets.addvar(PAM, temp)
resu <- lets.classvar(x = pamvar, pos = ncol(pamvar), xy = TRUE)
}
  
}
\author{
Bruno Vilela
}
\references{
Morales-Castilla et al. 2013. Range size patterns of New 
World oscine passerines (Aves): insights from differences among migratory
 and sedentary clades. Journal of Biogeography, 40, 2261-2273.
}

