% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cvRegularizeSEMInternal.R
\name{.cvRegularizeSEMInternal}
\alias{.cvRegularizeSEMInternal}
\title{.cvRegularizeSEMInternal}
\usage{
.cvRegularizeSEMInternal(
  lavaanModel,
  k,
  standardize,
  penalty,
  weights,
  returnSubsetParameters,
  tuningParameters,
  method,
  modifyModel,
  control
)
}
\arguments{
\item{lavaanModel}{model of class lavaan}

\item{k}{the number of cross-validation folds. Alternatively, a matrix with pre-defined subsets can be passed to the function.
See ?lessSEM::cvLasso for an example}

\item{standardize}{should training and test sets be standardized?}

\item{penalty}{string: name of the penalty used in the model}

\item{weights}{labeled vector with weights for each of the parameters in the
model.}

\item{returnSubsetParameters}{if set to TRUE, the parameter estimates of the individual cross-validation training sets will be returned}

\item{tuningParameters}{data.frame with tuning parameter values}

\item{method}{which optimizer should be used? Currently implemented are ista
and glmnet. With ista, the control argument can be used to switch to related procedures
(currently gist).}

\item{modifyModel}{used to modify the lavaanModel. See ?modifyModel.}

\item{control}{used to control the optimizer. This element is generated with
the controlIsta() and controlGlmnet() functions.}
}
\value{
model of class cvRegularizedSEM
}
\description{
Combination of regularized structural equation model and cross-validation
}
\details{
Internal function: This function computes the regularized models
for all penalty functions which are implemented for glmnet and gist.
Use the dedicated penalty functions (e.g., lessSEM::cvLasso) to penalize
the model.
}
\keyword{internal}
