% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coord-flex.r
\name{coord_flex_cart}
\alias{coord_flex_cart}
\alias{coord_flex_flip}
\alias{coord_flex_fixed}
\title{Cartesian coordinates with flexible options for drawing axes}
\usage{
coord_flex_cart(
  xlim = NULL,
  ylim = NULL,
  expand = TRUE,
  top = waiver(),
  left = waiver(),
  bottom = waiver(),
  right = waiver()
)

coord_flex_flip(
  xlim = NULL,
  ylim = NULL,
  expand = TRUE,
  top = waiver(),
  left = waiver(),
  bottom = waiver(),
  right = waiver()
)

coord_flex_fixed(
  ratio = 1,
  xlim = NULL,
  ylim = NULL,
  expand = TRUE,
  top = waiver(),
  left = waiver(),
  bottom = waiver(),
  right = waiver()
)
}
\arguments{
\item{xlim, ylim}{Limits for the x and y axes.}

\item{expand}{If \code{TRUE}, the default, adds a small expansion factor to
the limits to ensure that data and axes don't overlap. If \code{FALSE},
limits are taken exactly from the data or \code{xlim}/\code{ylim}.}

\item{top, left, bottom, right}{Function for drawing axis lines, ticks, and labels,
use e.g. \code{\link{capped_horizontal}} or \code{\link{brackets_horizontal}}.}

\item{ratio}{aspect ratio, expressed as \code{y / x}.}
}
\description{
Allows user to inject a function for drawing axes, such as
\code{\link{capped_horizontal}} or \code{\link{brackets_horizontal}}.
}
\details{
NB! A panel-border is typically drawn on top such that it covers tick marks,
grid lines, and axis lines.
Many themes also do not draw axis lines.
To ensure the modified axis lines are visible, use
\code{theme(panel.border=element_blank(), axis.line=element_line())}.
}
\section{User defined functions}{

The provided function in \code{top}, \code{right}, \code{bottom}, and \code{left}
defaults to \code{render_axis} which is defined in \file{ggplot2/R/coord-.r}, which in
turns calls \code{guide_axis} (see \file{ggplot2/R/guides-axis.r}).

The provided function is with the arguments
\code{scale_details}, \code{axis}, \code{scale}, \code{position}, and \code{theme},
and the function should return an \code{\link{absoluteGrob}} object.

For examples of modifying the drawn object, see e.g.
\code{\link{capped_horizontal}} or \code{\link{brackets_horizontal}}.
}

\examples{
library(ggplot2)
# A standard plot
p <- ggplot(mtcars, aes(disp, wt)) +
 geom_point() +
 geom_smooth() + theme(panel.border=element_blank(), axis.line=element_line())

# We desire that left axis does not extend beyond '6'
# and the x-axis is unaffected
p + coord_capped_cart(left='top')

# Specifying 'bottom' caps the axis with at most the length of 'gap'
p + coord_capped_cart(left='top', bottom='none')

# We can specify a ridiculus large 'gap', but the lines will always
# protrude to the outer most ticks.
p + coord_capped_cart(left='top', bottom='none', gap=2)

# We can use 'capped_horizontal' and 'capped_vertical' to specify for
# each axis individually.
p + coord_capped_cart(left='top', bottom=capped_horizontal('none', gap=2))

# At this point we might as well drop using the short-hand and go full on:
p + coord_flex_cart(left=brackets_vertical(), bottom=capped_horizontal('left'))

# Also works with secondary axes:
p + scale_y_continuous(sec.axis=sec_axis(~5*., name='wt times 5')) +
  coord_flex_cart(left=brackets_vertical(), bottom=capped_horizontal('right'),
  right=capped_vertical('both', gap=0.02))


# Supports the usual 'coord_fixed':
p + coord_flex_fixed(ratio=1.2, bottom=capped_horizontal('right'))

# and coord_flip:
p + coord_flex_flip(ylim=c(2,5), bottom=capped_horizontal('right'))
}
