% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{find_partition_with_rep_rcpp}
\alias{find_partition_with_rep_rcpp}
\title{Finds the optimal partition using the Leiden algorithm}
\usage{
find_partition_with_rep_rcpp(
  edgelist,
  edgelist_length,
  num_vertices,
  direction,
  edge_weights,
  resolution = 1,
  niter = 2L,
  nrep = 1L
)
}
\arguments{
\item{edgelist}{The graph edge list}

\item{edgelist_length}{integer The length of the graph edge list}

\item{num_vertices}{integer The number of vertices in the graph}

\item{direction}{boolean Whether the graph is directed or undirected}

\item{edge_weights}{Vector of edge weights. In weighted graphs, a real number is assigned to each (directed or undirected) edge. For an unweighted graph, this is set to 1. Refer to igraph, weighted graphs.}

\item{resolution}{Numeric scalar, resoluiton parameter controlling communities detected (default=1.0) Higher resolutions lead to more communities, while lower resolutions lead to fewer communities.}

\item{niter}{Number of iterations that the algorithm should be run for (default=2)}

\item{nrep}{Number of replicate starts with random number being updated. (default=10) The result with the best quality will be returned.}
}
\description{
Finds the optimal partition using the Leiden algorithm
}
\details{
For notes of the graph object, refer to https://igraph.org/c/doc/igraph-Basic.html
}
\examples{

library(igraph)

edgelist <- as.vector(t(igraph::as_edgelist(exampleGraph, names=FALSE))) - 1
edgelist_len <- length(edgelist)  ## The length of the graph edge list
n_vertices <- length(igraph::V(exampleGraph)) - 1  ## The number of vertices in the graph
direct <- igraph::is_weighted(exampleGraph)  ## Whether the graph is directed or undirected
edge_weights <- E(exampleGraph)$weight
find_partition_with_rep_rcpp(edgelist, edgelist_len, n_vertices, direct, edge_weights, nrep = 10)

}
