% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/communities.R
\name{rleiden.community}
\alias{rleiden.community}
\title{Recursive leiden communities
Constructs an n-step recursive clustering, using leiden.community}
\usage{
rleiden.community(
  graph,
  max.depth = 2,
  n.cores = parallel::detectCores(logical = FALSE),
  min.community.size = 10,
  verbose = FALSE,
  resolution = 1,
  cur.depth = 1,
  hierarchical = TRUE,
  ...
)
}
\arguments{
\item{graph}{graph}

\item{max.depth}{Recursive depth (default=2)}

\item{n.cores}{integer Number of cores to use (default = parallel::detectCores(logical=FALSE)). If logical=FALSE, uses the number of physical CPUs/cores. If logical=TRUE, uses the logical number of CPUS/cores. See parallel::detectCores()}

\item{min.community.size}{integer Minimal community size parameter for the walktrap communities---Communities smaller than that will be merged (default=10)}

\item{verbose}{boolean Whether to output progress messages (default=FALSE)}

\item{resolution}{resolution parameter passed to leiden.community (either a single value, or a value equivalent to max.depth) (default=1)}

\item{cur.depth}{integer Current depth of clustering (default=1)}

\item{hierarchical}{boolean If TRUE, calculate hierarchy on the multilevel clusters (default=TRUE)}

\item{...}{passed to leiden.community}
}
\value{
a fakeCommunities object that returns membership and dendrogram
}
\description{
Recursive leiden communities
Constructs an n-step recursive clustering, using leiden.community
}
\examples{
rleiden.community(exampleGraph, n.cores=1)

}
