% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popchar.R
\name{supplemental}
\alias{supplemental}
\title{Create an Data Frame of Supplemental Data for MPM Development}
\usage{
supplemental(
  stage3,
  stage2,
  stage1 = NA,
  eststage3 = NA,
  eststage2 = NA,
  eststage1 = NA,
  givenrate = NA,
  multiplier = NA,
  type = NA,
  stageframe,
  historical = TRUE
)
}
\arguments{
\item{stage3}{The name of the stage in time \emph{t}+1 in the transition to
be replaced.}

\item{stage2}{The name of the stage in time \emph{t} in the transition to be 
replaced.}

\item{stage1}{The name of the stage in time \emph{t}-1 in the transition to
be replaced. Only needed if a historical matrix is to be produced. Use
\code{rep} if all reproductive stages are to be used, \code{mat} if all
mature stages are to be used, \code{immat} if all immature stages are to be
used, \code{prop} if all propagule stages are to be used, and leave empty or
use \code{all} if all stages in stageframe are to be used.}

\item{eststage3}{The name of the stage to replace \code{stage3}. Only needed
if a transition will be replaced by another estimated transition.}

\item{eststage2}{The name of the stage to replace \code{stage2}. Only needed
if a transition will be replaced by another estimated transition.}

\item{eststage1}{The name of the stage to replace \code{stage1}. Only needed
if a transition will be replaced by another estimated transition, and the
matrix to be estimated is historical.}

\item{givenrate}{A fixed rate or probability to replace for the transition
described by \code{stage3}, \code{stage2}, and \code{stage1}.}

\item{multiplier}{A vector of numeric multipliers for fecundity, and NA
entries for all other terms.}

\item{type}{A vector denoting the kind of replacement to be performed. This
should be entered as \code{1}, \code{S}, or \code{s} for the replacement of a
survival transition; \code{2}, \code{F}, or \code{f} for the replacement of a
fecundity transition; or \code{3}, \code{R}, or \code{r} for a fecundity
multiplier. If empty or not provided, then defaults to 1 for survival
transition.}

\item{stageframe}{The stageframe being used to produce the MPMs in the study.}

\item{historical}{A logical value indicating whether the MPMs intended will
be historical or ahistorical. Defaults to TRUE.}
}
\value{
A data frame of class \code{lefkoSD}. This object can be used as
input in \code{\link{flefko3}()}, \code{\link{flefko2}()}, 
\code{\link{rlefko3}()}, \code{\link{rlefko2}()}, and 
\code{\link{aflefko2}()}.

Variables in this object include the following:
\item{stage3}{Stage at time \emph{t}+1 in the transition to be replaced.}
\item{stage2}{Stage at time \emph{t} in the transition to be replaced.}
\item{stage1}{Stage at time \emph{t}-1 in the transition to be replaced.}
\item{eststage3}{Stage at time \emph{t}+1 in the transition to replace the
transition designated by \code{stage3}, \code{stage2}, and \code{stage1}.}
\item{eststage2}{Stage at time \emph{t} in the transition to replace the
transition designated by \code{stage3}, \code{stage2}, and \code{stage1}.}
\item{eststage1}{Stage at time \emph{t}-1 in the transition to replace the
transition designated by \code{stage3}, \code{stage2}, and \code{stage1}.}
\item{givenrate}{A constant to be used as the value of the transition.}
\item{convtype}{Designates whether the transition is a survival transition
probability (1), a fecundity rate (2), or a fecundity multiplier (3).}
}
\description{
\code{supplemental()} provides all necessary supplemental data for matrix
estimation, particularly bringing together data on proxy rates, data to 
overwrite existing rates, identified reproductive transitions complete, and
fecundity multipliers.
}
\section{Notes}{

Fecundity multiplier data supplied via the \code{supplemental()} function
acts in the same way as non-zero entries supplied via a reproductive matrix,
but gets priority in all matrix creations. Thus, in cases where fecundity
multipliers are provided for the same function via the reproductive matrix
and function \code{supplemental()}, the latter is used.
}

\examples{
data(cypdata)

sizevector <- c(0, 0, 0, 0, 0, 0, 1, 2.5, 4.5, 8, 17.5)
stagevector <- c("SD", "P1", "P2", "P3", "SL", "D", "XSm", "Sm", "Md", "Lg",
  "XLg")
repvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
obsvector <- c(0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 1)
matvector <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
immvector <- c(0, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 0, 0, 0, 0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 0, 0, 0, 0, 0.5, 0.5, 1, 1, 2.5, 7)

cypframe_raw <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  propstatus = propvector, immstatus = immvector, indataset = indataset,
  binhalfwidth = binvec)

cypsupp2r <- supplemental(stage3 = c("SD", "P1", "P2", "P3", "SL", "SL", "D", 
    "XSm", "Sm", "SD", "P1"),
  stage2 = c("SD", "SD", "P1", "P2", "P3", "SL", "SL", "SL", "SL", "XLg", "XLg"),
  eststage3 = c(NA, NA, NA, NA, NA, NA, "D", "XSm", "Sm", NA, NA),
  eststage2 = c(NA, NA, NA, NA, NA, NA, "XSm", "XSm", "XSm", NA, NA),
  givenrate = c(0.1, 0.2, 0.2, 0.2, 0.25, 0.4, NA, NA, NA, NA, NA),
  multiplier = c(NA, NA, NA, NA, NA, NA, NA, NA, NA, 0.50, 0.35),
  type = c("S", "S", "S", "S", "S", "S", "S", "S", "S", "R", "R"),
  stageframe = cypframe_raw, historical = FALSE)

cypsupp2r

cypsupp3r <- supplemental(stage3 = c("SD", "SD", "P1", "P1", "P2", "P3", "SL", 
  "SL", "SL", "D", "XSm", "Sm", "D", "XSm", "Sm", "SD", "P1"), 
  stage2 = c("SD", "SD", "SD", "SD", "P1", "P2", "P3", "SL", "SL", "SL",
   "SL", "SL", "SL", "SL", "SL", "XLg", "XLg"),
  stage1 = c("SD", "rep", "SD", "rep", "SD", "P1", "P2", "P3", "SL", "P3",
   "P3", "P3", "SL", "SL", "SL", "XLg", "XLg"),
  eststage3 = c(NA, NA, NA, NA, NA, NA, NA, NA, NA, "D", "XSm", "Sm", "D",
   "XSm", "Sm", NA, NA), 
  eststage2 = c(NA, NA, NA, NA, NA, NA, NA, NA, NA, "XSm", "XSm", "XSm",
   "XSm", "XSm", "XSm", NA, NA), 
  eststage1 = c(NA, NA, NA, NA, NA, NA, NA, NA, NA, "XSm", "XSm", "XSm",
    "XSm", "XSm", "XSm", NA, NA),
  givenrate = c(0.1, 0.1, 0.2, 0.2, 0.2, 0.2, 0.25, 0.4, 0.4, NA, NA, NA, NA,
    NA, NA, NA, NA),
  multiplier = c(NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA, NA,
                 0.50, 0.35),
  type = c("S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S", "S",
    "S", "S", "R", "R"),
  stageframe = cypframe_raw, historical = TRUE)

cypsupp3r

}
