% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/popdyn.R
\name{repvalue3.matrix}
\alias{repvalue3.matrix}
\title{Estimate Reproductive Value for a Population Projection Matrix}
\usage{
\method{repvalue3}{matrix}(mats)
}
\arguments{
\item{mats}{A population projection matrix.}
}
\value{
This function returns a vector data frame characterizing the 
reproductive values for stages of a population projection matrix. This is 
given as the left eigenvector associated with largest real part of the
dominant eigenvalue, divided by the first non-zero element of the left 
eigenvector. Eigen analysis is handled by the \code{eig_gen}() function in
the C++ Armadillo library for square matrices with fewer than 400 rows, and
using the \code{eigs_gen}() function for larger matrices.
}
\description{
\code{repvalue3.matrix()} returns the reproductive values for stages in a 
population projection matrix. The function makes no assumptions about whether
the matrix is ahistorical and simply provides standard reproductive values
corresponding to each row, meaning that the overall reproductive values of
basic life history stages in a historical matrix are not provided (the 
\code{\link{repvalue3.lefkoMat}()} function estimates these on the basis of
stage description information provided in the \code{lefkoMat} object used as
input in that function). This function can handle large and sparse matrices,
and so can be used with large historical matrices, IPMs, age x stage
matrices, as well as smaller ahistorical matrices.
}
\examples{
data(lathyrus)

sizevector <- c(0, 100, 13, 127, 3730, 3800, 0)
stagevector <- c("Sd", "Sdl", "VSm", "Sm", "VLa", "Flo", "Dorm")
repvector <- c(0, 0, 0, 0, 0, 1, 0)
obsvector <- c(0, 1, 1, 1, 1, 1, 0)
matvector <- c(0, 0, 1, 1, 1, 1, 1)
immvector <- c(1, 1, 0, 0, 0, 0, 0)
propvector <- c(1, 0, 0, 0, 0, 0, 0)
indataset <- c(0, 1, 1, 1, 1, 1, 1)
binvec <- c(0, 100, 11, 103, 3500, 3800, 0.5)

lathframe <- sf_create(sizes = sizevector, stagenames = stagevector,
  repstatus = repvector, obsstatus = obsvector, matstatus = matvector,
  immstatus = immvector, indataset = indataset, binhalfwidth = binvec,
  propstatus = propvector)

lathvert <- verticalize3(lathyrus, noyears = 4, firstyear = 1988,
  patchidcol = "SUBPLOT", individcol = "GENET", blocksize = 9,
  juvcol = "Seedling1988", sizeacol = "Volume88", repstracol = "FCODE88",
  fecacol = "Intactseed88", deadacol = "Dead1988",
  nonobsacol = "Dormant1988", stageassign = lathframe, stagesize = "sizea",
  censorcol = "Missing1988", censorkeep = NA, censor = TRUE)

lathrepm <- matrix(0, 7, 7)
lathrepm[1, 6] <- 0.345
lathrepm[2, 6] <- 0.054

lathover3 <- overwrite(stage3 = c("Sd", "Sd", "Sdl"),
  stage2 = c("Sd", "Sd", "Sd"), stage1 = c("Sd", "rep", "rep"),
  givenrate = c(0.345, 0.345, 0.054))

ehrlen3 <- rlefko3(data = lathvert, stageframe = lathframe,
  year = c(1989, 1990), stages = c("stage3", "stage2", "stage1"),
  repmatrix = lathrepm, overwrite = lathover3, yearcol = "year2",
  indivcol = "individ", reduce = TRUE)

ehrlen3mean <- lmean(ehrlen3)
repvalue3(ehrlen3mean$A[[1]])

}
\seealso{
\code{\link{repvalue3}()}

\code{\link{repvalue3.lefkoMat}()}
}
