% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cumulative_avg_models.R
\name{ca_block}
\alias{ca_block}
\title{Wright's Cumulative Average Learning Curve Function}
\usage{
ca_block(t, n, r, m = 1, na.rm = FALSE)
}
\arguments{
\item{t}{time (or cost) required for the mth unit of production}

\item{n}{last unit of the production block of concern}

\item{r}{learning curve rate}

\item{m}{first unit of the production block of concern (default: m = 1)}

\item{na.rm}{Should \code{NA} values be removed?}
}
\description{
Computes cumulative time or cost for units m through n in a production block using Wright's cumulative average model. Assumes the block begins at unit m and ends at unit n.
}
\examples{
# Production of the first 200 units of a product is nearing its
# end. Your customer said he is willing to buy an additional 50
# units. There will be no break in production or in learning. The
# first unit required 75 hours and the first 200 units had an 85\%
# learning curve. How many hours will the second block of 50 units
# require?

ca_block(t = 75, m = 201, n = 250, r = .85)
## [1] 806.772

}
