% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/velocity.R
\name{velocityOptions}
\alias{velocityOptions}
\title{velocityOptions}
\usage{
velocityOptions(
  speedUnit = c("m/s", "k/h", "kt"),
  minVelocity = 0,
  maxVelocity = 10,
  velocityScale = 0.005,
  colorScale = NULL,
  ...
)
}
\arguments{
\item{speedUnit}{Could be 'm/s' for meter per second, 'k/h' for kilometer
per hour or 'kt' for knots}

\item{minVelocity}{velocity at which particle intensity is minimum}

\item{maxVelocity}{velocity at which particle intensity is maximum}

\item{velocityScale}{scale for wind velocity}

\item{colorScale}{A vector of hex colors or an RGB matrix}

\item{...}{Further arguments passed to the Velocity layer and Windy.js.
For more information, please visit \href{https://github.com/onaci/leaflet-velocity}{leaflet-velocity plugin}}
}
\value{
A list of further options for \code{addVelocity}
}
\description{
Define further options for the velocity layer.
}
\seealso{
Other Velocity Functions: 
\code{\link{addVelocity}()},
\code{\link{removeVelocity}()},
\code{\link{setOptionsVelocity}()}
}
\concept{Velocity Functions}
