% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glify-shiny.R
\name{leafglOutput}
\alias{leafglOutput}
\alias{renderLeafgl}
\title{Use leafgl in shiny}
\usage{
leafglOutput(outputId, width = "100\%", height = 400)

renderLeafgl(expr, env = parent.frame(), quoted = TRUE)
}
\arguments{
\item{outputId}{output variable to read from}

\item{width, height}{the width and height of the map}

\item{expr}{An expression that generates an HTML widget}

\item{env}{The environment in which to evaluate expr.}

\item{quoted}{Is expr a quoted expression (with quote())?
This is useful if you want to save an expression in a variable.}
}
\value{
A UI for rendering leafgl

A server function for rendering leafgl
}
\description{
Use leafgl in shiny
}
\details{
See \link[leaflet:map-shiny]{leaflet::leafletOutput} for details.
  \code{renderLeafgl} is only exported for consistency. You can just as well
  use \link[leaflet:map-shiny]{leaflet::renderLeaflet} (see example).
  \code{leafglOutput} on the other hand is needed as it will attach all
  necessary dependencies.
}
\examples{
if (interactive()) {
library(shiny)
library(leaflet)
library(leafgl)
library(sf)

n = 1e4
df1 = data.frame(id = 1:n,
    x = rnorm(n, 10, 3),
    y = rnorm(n, 49, 1.8))
pts = st_as_sf(df1, coords = c("x", "y"), crs = 4326)

m = leaflet() \%>\%
 addProviderTiles(provider = providers$CartoDB.DarkMatter) \%>\%
 addGlPoints(data = pts, group = "pts") \%>\%
 setView(lng = 10.5, lat = 49.5, zoom = 6) \%>\%
 addLayersControl(overlayGroups = "pts")

ui <- fluidPage(
    leafglOutput("mymap")
)

server <- function(input, output, session) {
    output$mymap <- renderLeaflet(m)
}

shinyApp(ui, server)
}

}
