% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{GC}
\alias{GC}
\title{Gini coefficient of foliage structural diversity}
\usage{
GC(normlas.file, threshold = 1)
}
\arguments{
\item{normlas.file}{normalized las file}

\item{threshold}{numerical, defines the minimum height considered to represent an echo from leaves.}
}
\description{
Calculates the Gini coefficient (GC) from individual LIDAR returns (i.e. without voxelization),
as described for the L-coefficient of variation (equivalent to Gini) in Valbuena et al. (2017).
}
\note{
Valbuena et al. (2012) argues on why Gini is better suited to describe structural complexity the Foliage Height Diversity or the Gini-Simpon index.
}
\examples{
# Get the example laz file
normlas.file = system.file("extdata", "lidar_example.laz", package="leafR")

GC(normlas.file, threshold =1)

}
\references{
Valbuena R., Packalen P., Martín-Fernández S., Maltamo M. (2012) Diversity and equitability ordering profiles applied to the study of forest structure. Forest Ecology and Management 276: 185–195. http://dx.doi.org/10.1016/j.foreco.2012.03.036
Valbuena R., Maltamo M., Mehtätalo L., Packalen P. (2017) Key structural features of Boreal forests may be detected directly using L-moments from airborne lidar data. Remote Sensing of Environment. 194: 437–446. https://doi.org/10.1016/j.rse.2016.10.024
}
