% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{get.options.neldermead}
\alias{get.options.neldermead}
\title{Options for Nelder-Mead Optimization}
\usage{
get.options.neldermead(
  maxIterations = 100,
  tolerance = 1e-06,
  reflection = 1,
  expansion = 2,
  contraction = 0.5,
  shrink = 1
)
}
\arguments{
\item{maxIterations}{(int) Maximum number of iterations.}

\item{tolerance}{A small number to determine the convergence.
The algorithm terminates when the difference between the best and worst points in the simplex is less than this value.}

\item{reflection}{A number for reflection coefficient.
It controls how far the worst point is reflected through the centroid of the remaining points.}

\item{expansion}{A number that determines the expansion coefficient.
It controls how far the reflected point is expanded along the line connecting it to the centroid.}

\item{contraction}{A number that determines the contraction coefficient.
It controls how far the worst point is contracted towards the centroid.}

\item{shrink}{A number that determines the shrink coefficient.
It controls how much the simplex is shrunk towards the best point when all other moves are rejected.}
}
\value{
A list with the given options.
}
\description{
Use this function to get the required options when Nelder-Mead optimization is needed such as \link{s.gld.from.moments} function.
}
