% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/varma.R
\name{search.varma.stepwise}
\alias{search.varma.stepwise}
\title{Step-wise Search for Best VARMA Models}
\usage{
search.varma.stepwise(
  y,
  ySizeSteps = list(c(1, 2), c(3)),
  countSteps = c(NA, 10),
  savePre = NULL,
  ...
)
}
\arguments{
\item{y}{A matrix of endogenous data with variables in the columns.}

\item{ySizeSteps}{A list of model dimensions to be estimated in each step.
Its size determines the number of steps.}

\item{countSteps}{An integer vector to determine the number of variables to be used in each step.
\code{NA} means all variables. Variables are selected based on best estimations.
All variables in the best models (all metrics and targets) are selected until the corresponding suggested number is reached.
Select an appropriate value for \code{bestK} in the options.}

\item{savePre}{A directory for saving and loading the progress.
Each step's result is saved in a file (name=\code{paste0(savePre,i)} where \code{i} is the index of the step.}

\item{...}{other arguments to pass to \link{search.varma} function such as the \code{x} argument.
Note that \code{ySizes} is ineffective here.}
}
\value{
Similar to \link{search.varma} function.
}
\description{
For a large model set, use this function to find the best Vector Autoregressive Moving Average models.
It selects a subset of variables from smaller models and moves to the bigger ones.
}
\examples{
# See the example in the 'search.varma' function.

}
\seealso{
\link{search.varma}, \link{estim.varma}
}
