% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_exhaustive.R
\name{estimate_exhaustive}
\alias{estimate_exhaustive}
\title{Estimates the maximum number of cases to be checked during exhaustive search.}
\usage{
estimate_exhaustive(min_preserved = sum(group_sizes), condition,
  cases_per_second = 100, print_info = TRUE, max_removed = NULL,
  group_sizes = NULL, props = NULL)
}
\arguments{
\item{min_preserved}{Assumes that at least a total of this many subjects
will be preserved.}

\item{condition}{A factor vector containing condition labels.}

\item{cases_per_second}{Assumes that this number of cases are checked out
per second, for estimating the time it takes to run
the exhaustive search; default: 100.}

\item{print_info}{If TRUE, prints partial calculations as well for
the number of cases and estimated time when removing
1, 2, ... subjects.}

\item{max_removed}{A named integer vector, containing the maximum number
of subjects that can be removed from each group.
Specify 0 for groups if you want to preserve
all of their subjects. If you do not specify a value
for a group, it defaults to one less than the group size.
Values outside the valid range of 0..(N-1)
(where N is the number of subjects in the group)
are corrected without a warning.}

\item{group_sizes}{A particular set of group sizes that we know a
matched solution for; min_preserved need not be
specified if this one is.}

\item{props}{The desired proportions (percentage) of the sample
for each condition; if this and group_sizes are both
specified, the maximum number of cases to considered
by the exhaustive search can be calculated more
precisely.}
}
\value{
The maximum number of cases: an integer if not greater than the
maximum integer size (.Machine$integer.max), otherwise a Big Integer
(see the gmp package).
}
\description{
Estimates the maximum number of cases to be checked during exhaustive search.
}
\examples{
estimate_exhaustive(58, as.factor(c(rep("ALN", 25), rep("TD", 44))))
estimate_exhaustive(84, as.factor(c(rep("ASD", 51), rep("TD", 44))))

}

