% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geojsontype.R
\name{lawn_geosjontype}
\alias{lawn_geosjontype}
\title{Enforce expectations about types of GeoJSON objects.}
\usage{
lawn_geosjontype(x, type, name, lint = FALSE)
}
\arguments{
\item{x}{value of any \link{data-GeoJSON} object. required.}

\item{type}{expected GeoJSON type. required.}

\item{name}{name of calling function. required.}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing
time as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good
geojson objects. Default: \code{FALSE}}
}
\value{
nothing if no problems - error message if a problem
}
\description{
Enforce expectations about types of GeoJSON objects.
}
\examples{
# all okay
x <- "{ type: 'Point', coordinates: [10, 50] }"
lawn_geosjontype(x, 'Point', 'fooBar')

# error
# lawn_geosjontype(x, 'Polygon', 'fooBar')
}
\seealso{
Other invariant: 
\code{\link{lawn_collectionof}()},
\code{\link{lawn_featureof}()}
}
\concept{invariant}
