% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/boolean_pointonline.R
\name{lawn_boolean_pointonline}
\alias{lawn_boolean_pointonline}
\title{Boolean overlap}
\usage{
lawn_boolean_pointonline(point, linestring, ignoreEndVertices = FALSE,
  lint = FALSE)
}
\arguments{
\item{point}{any \link{data-Geometry}/\href{[data-Point]}{data-Feature}}

\item{linestring}{any \link{data-Geometry}/\href{[data-LineString]}{data-Feature}}

\item{ignoreEndVertices}{(logical) whether to ignore the start and end
vertices. Default: `FALSE}

\item{lint}{(logical) Lint or not. Uses geojsonhint. Takes up increasing
time as the object to get linted increases in size, so probably use by
default for small objects, but not for large if you know they are good
geojson objects. Default: \code{FALSE}}
}
\value{
a logical (\code{TRUE}/\code{FALSE})
}
\description{
Boolean overlap
}
\examples{
l1 <- "[[-1, -1],[1, 1],[1.5, 2.2]]"
lawn_boolean_pointonline(lawn_point("[0, 0]"), lawn_linestring(l1))
}
\seealso{
Other boolean functions: \code{\link{lawn_boolean_clockwise}},
  \code{\link{lawn_boolean_contains}},
  \code{\link{lawn_boolean_crosses}},
  \code{\link{lawn_boolean_disjoint}},
  \code{\link{lawn_boolean_overlap}},
  \code{\link{lawn_boolean_within}}
}
