% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/link.R
\name{setLink}
\alias{setLink}
\alias{setLink.lvm}
\title{Set a Link to a Value}
\usage{
setLink(object, ...)

\method{setLink}{lvm}(object, var1, var2, value, warnings = FALSE, ...)
}
\arguments{
\item{object}{a \code{lvm} object.}

\item{...}{[internal] only used by the generic method.}

\item{var1}{[character or formula] the exogenous variable of the new link or a formula describing the link to be added to the lvm.}

\item{var2}{[character] the endogenous variable of the new link. Disregarded if the argument \code{var1} is a formula.}

\item{value}{[numeric] the value at which the link should be set.}

\item{warnings}{[logical] should a warning be displayed if the link is not found in the \code{lvm} object.}
}
\description{
Generic interface to set a value to a link in a \code{lvm} object.
}
\examples{
library(lava)
set.seed(10)

m <- lvm()
regression(m) <- c(y1,y2,y3)~u
regression(m) <- u~x1+x2
latent(m) <- ~u
covariance(m) <- y1 ~ y2

m1 <- setLink(m, y3 ~ u, value = 1)
estimate(m1, lava::sim(m,1e2))
# m1 <- setLink(m, u ~ y3, value = 1)

m2 <- setLink(m, y1 ~ y2, value = 0.5)
estimate(m2, lava::sim(m,1e2))

}
\concept{
setter
}
