% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/defineCategoricalLink.R
\name{defineCategoricalLink}
\alias{defineCategoricalLink}
\alias{defineCategoricalLink.lvm}
\title{Identify Categorical Links in LVM}
\usage{
defineCategoricalLink(object, link, data)

\method{defineCategoricalLink}{lvm}(object, link = NULL, data = NULL)
}
\arguments{
\item{object}{a \code{lvm} model.}

\item{link}{[character] the links to be analyzed. If \code{NULL}, all the coefficients from the lvm model are used instead.}

\item{data}{[data.frame] the dataset that will be used to fit the model. If \code{NULL}, a simulated data will be generated from the model.}
}
\value{
a \code{data.frame} with a description of each link in rows. \cr
The column factitious identify the links that will be replaced with other links
(e.g. "Y1~X1" becomes "Y1~X1b" and "Y1~X1c"). \cr
}
\description{
Identify categorical links in latent variable models.
}
\examples{
\dontrun{
defineCategoricalLink <- lavaSearch2:::defineCategoricalLink
defineCategoricalLink.lvm <- lavaSearch2:::defineCategoricalLink.lvm

## linear model
m <- lvm(Y1~X1+X2,Y2~X1+X3)
categorical(m, K = 3) <- "X1"
try(defineCategoricalLink(m)) # error

categorical(m, K = 3, labels = 1:3) <- "X1"
defineCategoricalLink(m)
defineCategoricalLink(m, "Y~X1")
defineCategoricalLink(m, "X1:0|1")
defineCategoricalLink(m, "X1:1|2")
defineCategoricalLink(m, c("X1:0|1", "X1:1|2"))
defineCategoricalLink(m, c("Y~X1","Y~X2"))
defineCategoricalLink(m, c("Y~X2","Y~X1"))

## latent variable model
m <- lvm()
regression(m) <- c(y1,y2,y3)~u
regression(m) <- u~x1+x2
latent(m) <- ~u
covariance(m) <- y1~y2
categorical(m, labels = as.character(1:3)) <- "X1"

defineCategoricalLink(m)
}

}
\concept{
setter
}
\keyword{internal}
