% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/latrend.R
\name{latrendCV}
\alias{latrendCV}
\title{Cluster longitudinal data over k folds}
\usage{
latrendCV(
  method,
  data,
  folds = 10,
  seed = NULL,
  parallel = FALSE,
  errorHandling = "stop",
  envir = NULL,
  verbose = getOption("latrend.verbose")
)
}
\arguments{
\item{method}{An \code{lcMethod} object specifying the longitudinal cluster method to apply, or the name (as \code{character}) of an \code{lcMethod} subclass. See \linkS4class{lcMethod} for details.}

\item{data}{A \code{data.frame}.}

\item{folds}{The number of folds. Ten folds by default.}

\item{seed}{The seed to use. Optional.}

\item{parallel}{Whether to enable parallel evaluation. See \link{latrend-parallel}. Method evaluation and dataset transformation is done on the calling thread.}

\item{errorHandling}{Whether to \code{"stop"} on an error, or to \verb{"remove'} evaluations that raised an error.}

\item{envir}{The \code{environment} in which to evaluate the method arguments (by \code{\link[=compose]{compose()}}). This environment is also used to evaluate the \code{data} argument if it is of type \code{call}.}

\item{verbose}{The level of verbosity. Either an object of class \code{Verbose} (see \link[R.utils:Verbose]{R.utils::Verbose} for details),
a \code{logical} indicating whether to show basic computation information,
a \code{numeric} indicating the verbosity level (see \link{Verbose}),
or one of \code{c('info', 'fine', 'finest')}.}
}
\value{
A \code{lcModels} object of containing the \code{folds} training models.
}
\description{
Apply k-fold cross validation for internal cluster validation.
Creates k random subsets ("folds") from the data, estimating a model for each of the k-1 combined folds.
}
\examples{
data(latrendData)
method <- lcMethodLMKM(Y ~ Time, id = "Id", time = "Time")

if (require("caret")) {
  model <- latrendCV(method, latrendData, folds = 5, seed = 1)

  model <- latrendCV(method, subset(latrendData, Time < .5), folds = 5)
}
}
\seealso{
Other longitudinal cluster fit functions: 
\code{\link{latrendBatch}()},
\code{\link{latrendBoot}()},
\code{\link{latrendRep}()},
\code{\link{latrend}()}

Other validation methods: 
\code{\link{createTestDataFolds}()},
\code{\link{createTestDataFold}()},
\code{\link{createTrainDataFolds}()},
\code{\link{latrendBoot}()},
\code{\link{lcModel-data-filters}}
}
\concept{longitudinal cluster fit functions}
\concept{validation methods}
