% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{plotFittedTrajectories}
\alias{plotFittedTrajectories}
\alias{plotFittedTrajectories,lcModel-method}
\title{Plot fitted trajectories of a lcModel}
\usage{
\S4method{plotFittedTrajectories}{lcModel}(object, ...)
}
\arguments{
\item{object}{The \code{lcModel} object.}

\item{...}{
  Arguments passed on to \code{\link[=trajectories]{trajectories}}
  \describe{
    \item{\code{id}}{The identifier variable name.}
    \item{\code{time}}{The time variable name.}
    \item{\code{response}}{The response variable name.}
  }}
}
\description{
Plot fitted trajectories of a lcModel
}
\examples{
data(latrendData)
method <- lcMethodLMKM(Y ~ Time, id = "Id", time = "Time")
model <- latrend(method, latrendData, nClusters = 3)

if (require("ggplot2")) {
  plotFittedTrajectories(model)
}
}
\seealso{
\link{fittedTrajectories} \link{plotClusterTrajectories} \link{plotTrajectories} \link{plot}
}
