% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methodRandom.R
\name{lcMethodRandom}
\alias{lcMethodRandom}
\title{Specify a random-partitioning method}
\usage{
lcMethodRandom(
  response,
  alpha = 10,
  center = meanNA,
  time = getOption("latrend.time"),
  id = getOption("latrend.id"),
  nClusters = 2,
  name = "random",
  ...
)
}
\arguments{
\item{response}{The name of the response variable.}

\item{alpha}{The Dirichlet parameters. Either \code{scalar} or of length \code{nClusters}. The higher alpha, the more uniform the clusters will be.}

\item{center}{Optional \code{function} for computing the longitudinal cluster centers, with signature \code{(x)}.}

\item{time}{The name of the time variable.}

\item{id}{The name of the trajectory identification variable.}

\item{nClusters}{The number of clusters.}

\item{name}{The name of the method.}

\item{...}{Additional arguments, such as the seed.}
}
\description{
Creates a model with random cluster assignments according to the random cluster proportions drawn from a Dirichlet distribution.
}
\examples{
data(latrendData)
method <- lcMethodRandom(response = "Y", id = "Id", time = "Time")
model <- latrend(method, latrendData)

# uniform clusters
method <- lcMethodRandom(alpha = 1e3, nClusters = 3, response = "Y", id = "Id", time = "Time")

# single large cluster
method <- lcMethodRandom(alpha = c(100, 1, 1, 1), nClusters = 4,
  response = "Y", id = "Id", time = "Time")
}
\references{
\insertRef{frigyik2010introduction}{latrend}
}
\seealso{
Other lcMethod implementations: 
\code{\link{getArgumentDefaults}()},
\code{\link{getArgumentExclusions}()},
\code{\link{lcMethod-class}},
\code{\link{lcMethodAkmedoids}},
\code{\link{lcMethodCrimCV}},
\code{\link{lcMethodCustom}},
\code{\link{lcMethodDtwclust}},
\code{\link{lcMethodFeature}},
\code{\link{lcMethodFunFEM}},
\code{\link{lcMethodGCKM}},
\code{\link{lcMethodKML}},
\code{\link{lcMethodLMKM}},
\code{\link{lcMethodLcmmGBTM}},
\code{\link{lcMethodLcmmGMM}},
\code{\link{lcMethodLongclust}},
\code{\link{lcMethodMclustLLPA}},
\code{\link{lcMethodMixAK_GLMM}},
\code{\link{lcMethodMixtoolsGMM}},
\code{\link{lcMethodMixtoolsNPRM}},
\code{\link{lcMethodStratify}}
}
\concept{lcMethod implementations}
