% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{plot.lass0}
\alias{plot.lass0}
\title{Visualizing Lasso-Zero's estimates}
\usage{
\method{plot}{lass0}(x, ...)
}
\arguments{
\item{x}{a \code{"lass0"} object}

\item{...}{further arguments that can be passed to \code{plot}}
}
\description{
Plots the regression coefficients obtained by Lasso-Zero.
}
\details{
For a \code{"lass0"} object, produces boxplots of the \code{M} obtained
estimates for each regression coefficient and indicates the threshold level
\code{tau}. Coefficients whose median is larger than \code{tau} is absolute
value are the ones selected by Lasso-Zero. Note that if \code{lass0} was
called with \code{standardizeX = TRUE}, the coefficients and threshold are
represented on the standardized scale.
}
\references{
Descloux, P., & Sardy, S. (2018). Model selection with
  lasso-zero: adding straw to the haystack to better find needles. arXiv
  preprint arXiv:1805.05133. \url{https://arxiv.org/abs/1805.05133}
}
\seealso{
\code{\link{lass0}} and \code{\link{qut.MC}}
}
