% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missings.R
\name{impute}
\alias{impute}
\title{Impute Missing Values (using MICE)}
\usage{
impute(df, m = 5, iters = 5, seed = 0, quiet = FALSE)
}
\arguments{
\item{df}{Dataframe. Dataframe to transform.}

\item{m}{Integer. Number of multiple imputations.}

\item{iters}{Integer. Number of iterations.}

\item{seed}{Integer. Set a seed for reproducibility.}

\item{quiet}{Boolean. Keep quiet? (or print replacements).}
}
\value{
data.frame with imputed values.
}
\description{
This function uses the MICE methodology to impute missing values.
}
\seealso{
Other Data Wrangling: 
\code{\link{balance_data}()},
\code{\link{categ_reducer}()},
\code{\link{cleanText}()},
\code{\link{date_cuts}()},
\code{\link{date_feats}()},
\code{\link{file_name}()},
\code{\link{formatHTML}()},
\code{\link{holidays}()},
\code{\link{left}()},
\code{\link{normalize}()},
\code{\link{num_abbr}()},
\code{\link{ohe_commas}()},
\code{\link{ohse}()},
\code{\link{quants}()},
\code{\link{removenacols}()},
\code{\link{replaceall}()},
\code{\link{replacefactor}()},
\code{\link{textFeats}()},
\code{\link{textTokenizer}()},
\code{\link{vector2text}()},
\code{\link{year_month}()},
\code{\link{zerovar}()}

Other Machine Learning: 
\code{\link{ROC}()},
\code{\link{conf_mat}()},
\code{\link{export_results}()},
\code{\link{gain_lift}()},
\code{\link{h2o_automl}()},
\code{\link{h2o_predict_API}()},
\code{\link{h2o_predict_MOJO}()},
\code{\link{h2o_predict_binary}()},
\code{\link{h2o_predict_model}()},
\code{\link{h2o_selectmodel}()},
\code{\link{iter_seeds}()},
\code{\link{lasso_vars}()},
\code{\link{model_metrics}()},
\code{\link{model_preprocess}()},
\code{\link{msplit}()}

Other Missing Values: 
\code{\link{missingness}()}
}
\concept{Data Wrangling}
\concept{Machine Learning}
\concept{Missing Values}
