% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wordle.R
\name{wordle_check}
\alias{wordle_check}
\alias{print.wordle_check}
\alias{wordle_dictionary}
\alias{wordle_simulation}
\alias{print.wordle_simulation}
\title{Wordle Game Validation}
\usage{
wordle_check(
  input,
  word,
  dictionary = NULL,
  lang_dic = "en",
  method = 3,
  print = TRUE
)

\method{print}{wordle_check}(x, print = TRUE, ...)

wordle_dictionary(lang_dic = "en", method = 3, quiet = TRUE)

wordle_simulation(input, word, seed = NULL, quiet = FALSE, ...)

\method{print}{wordle_simulation}(x, type = 1, ...)
}
\arguments{
\item{input}{Character. Word to validate (5-letters)}

\item{word}{Character. Word actually answer (5-letters).}

\item{dictionary}{Character vector. List of valid words. If set to NULL
then will use modified \code{scrabble_dictionary()} to fetch 5 letter words.
Use \code{lang_dic} param to set language.}

\item{lang_dic}{Character. Any of: "en", "es". Only used when \code{dictionary}
parameter is NULL. Requires internet connection the first time. Uses cache.}

\item{method}{Integer. 1 for \code{scrabble_dictionary()}, 3 for scrapping
the words taken straight from the game's source code.}

\item{print}{Boolean. Print validation results?}

\item{x}{Object to print}

\item{...}{Additional parameters to pass.}

\item{quiet}{Boolean. Do not print words as they are being searched.}

\item{seed}{Numeric. For reproducibility. Accepts more than one: will
run as many seeds there are.}

\item{type}{Integer. 1 for summary and 2 for coloured results.}
}
\value{
Invisible vector with results by letter.
}
\description{
Given and input and a word, validate each letter based on Wordle's
rules: correct letter in correct placement (green), correct letter in wrong
placement (yellow), letter is not present (red).
}
\examples{
word <- "ABBEY"
# Or pick a random one:
# word <- sample(wordle_dictionary("en"), 1)
wordle_check("OPENS", word)
wordle_check("BABES", word)
wordle_check("KEBAB", word, print = FALSE)
wordle_check("ABYSS", word)
wordle_check("ABBEY", word)
# Feel free to use scrabble_words() for hints

x <- wordle_simulation(input = "SAINT", word = "ABBEY", seed = 1:3)
print(x)
# hist(sapply(x, function(x) x$iters))
}
