% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stocks.R
\name{etf_sector}
\alias{etf_sector}
\title{ETF's Sectors Breakdown}
\usage{
etf_sector(etf = "VTI", quiet = FALSE, cache = TRUE)
}
\arguments{
\item{etf}{Character Vector. Which ETFs you wish to scrap?}

\item{quiet}{Boolean. Keep quiet? If not, informative messages will be printed.}

\item{cache}{Boolean. Use daily cache if available?}
}
\value{
data.frame with ETF break.down data by sector
}
\description{
This function scraps etf.com data for sector breakdown on ETFs.
Use \code{splot_etf()} for visualization.
}
\examples{
\donttest{
etf_sector(etf = "VTI")
}
}
\seealso{
Other Investment: 
\code{\link{daily_portfolio}()},
\code{\link{daily_stocks}()},
\code{\link{splot_change}()},
\code{\link{splot_divs}()},
\code{\link{splot_etf}()},
\code{\link{splot_growth}()},
\code{\link{splot_roi}()},
\code{\link{splot_summary}()},
\code{\link{splot_types}()},
\code{\link{stocks_file}()},
\code{\link{stocks_obj}()},
\code{\link{stocks_quote}()},
\code{\link{stocks_report}()}
}
\concept{Investment}
