% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_functions.R
\name{replaceall}
\alias{replaceall}
\title{Replace Values With}
\usage{
replaceall(df, original, change, which = "all", fixclass = TRUE, quiet = TRUE)
}
\arguments{
\item{df}{Data.frame or Vector}

\item{original}{String or Vector. Original text you wish to replace}

\item{change}{String or Vector. Values you wish to replace the originals with}

\item{which}{Character vector. Name of columns to use. Leave "all" for everything}

\item{fixclass}{Boolean. Try to detect logical classes after transformations (or
leave as default classes as character)?}

\item{quiet}{Boolean. Keep quiet? (or print replacements)}
}
\value{
data.frame with replaced values based on inputs.
}
\description{
This function lets the user replace all specific values in a
vector or data.frame into another value. If replacing more than
one value, order matters so they will be replaced in the same
order that you pass them to the function. Factors will be refactored.
}
\examples{
df <- data.frame(
  one = c(1:4, NA),
  two = LETTERS[1:5],
  three = rep("A", 5),
  four = c(NA, "Aaa", 123, "B", "C")
)
print(df)

replaceall(df, "A", NA)

replaceall(df, "A", "a")

replaceall(df, 1, "*")

replaceall(df, NA, "NotNA")

replaceall(df, NA, 0)

replaceall(df, c("A", "B"), c("'A'", "'B'"))

replaceall(df, "a", "*", which = "four")
}
\seealso{
Other Data Wrangling: 
\code{\link{balance_data}()},
\code{\link{categ_reducer}()},
\code{\link{cleanText}()},
\code{\link{date_cuts}()},
\code{\link{date_feats}()},
\code{\link{formatNum}()},
\code{\link{holidays}()},
\code{\link{impute}()},
\code{\link{left}()},
\code{\link{normalize}()},
\code{\link{ohe_commas}()},
\code{\link{ohse}()},
\code{\link{removenacols}()},
\code{\link{textFeats}()},
\code{\link{textTokenizer}()},
\code{\link{vector2text}()},
\code{\link{year_month}()}

Other Text Mining: 
\code{\link{cleanText}()},
\code{\link{ngrams}()},
\code{\link{remove_stopwords}()},
\code{\link{sentimentBreakdown}()},
\code{\link{textCloud}()},
\code{\link{textFeats}()},
\code{\link{textTokenizer}()},
\code{\link{topics_rake}()}
}
\concept{Data Wrangling}
\concept{Text Mining}
