% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/credentials.R
\name{get_credentials}
\alias{get_credentials}
\alias{get_creds}
\title{Load Credentials from a YML File}
\usage{
get_credentials(
  from = NA,
  dir = NA,
  filename = "config.yml",
  env = "LARES_CREDS"
)

get_creds(from = NA, dir = NA, filename = "config.yml", env = "LARES_CREDS")
}
\arguments{
\item{from}{Character. Family of values to import from the YML file.
If you don't know these names, set \code{from = NA}
and a warning will display all possible values, depending on your YML file.}

\item{dir}{Character. Credentials directory where your YML file is.
If used frequently, set your directory by using the \code{.Renviron} file.
To do so, leave \code{dir} as \code{NA} and follow the steps.
If \code{dir} is a list, it'll return \code{dir} (manual credentials input).}

\item{filename}{Character. YML filename with your credentials.}

\item{env}{Character. Environment variable name. No need to set differently
for any function that uses this library. Only for external use.}
}
\value{
List. Result of reading your credential's YML file, filtered by your
\code{from} input if provided.
}
\description{
Load credentials from a local YML file. You can set your \code{.Renviron}
and the \code{LARES_CREDS} parameter to remember (forever) the directory
of your credentials' file. To use it later, you may leave \code{dir = NA}.
You may also use this function for external (non-\code{lares}) code/use.
}
\section{Set the default directory}{

The first time you use any function that has the \code{creds} parameter, if
the \code{dir} parameter is set to \code{NA}, this function will ask you to
set the directory where you save your YML local file with your credentials.
This will be asked once and will be set for further R sessions. Remember to
reset your session for this setup to start working properly.
}

\section{YML file format}{

A YML file is a text file, with \code{.yml} file format. You may start from
the dummy YML file shared which shows the structure you must follow to set your
credentials file. Check it out
\href{https://raw.githubusercontent.com/laresbernardo/lares/master/inst/docs/config.yml}{here}
or find it locally using \code{system.file("docs", "config.yml", package = "lares")}.
}

\examples{
\dontrun{
# Load dummy config.yml file from the library
# Recommendation: set dir with NA (read documentation)
# We need the directory, not the file
yml <- dirname(system.file("docs", "config.yml", package = "lares"))

# Let's see which credentials we have in our file
get_credentials(dir = yml)
# Warning message: No credentials for NA found in your YML file.
# Try any of the following: 'service1', 'service2', 'service3'

# Get credentials for service2
get_credentials("service2", dir = yml)
}
}
\seealso{
Other Tools: 
\code{\link{autoline}()},
\code{\link{bind_files}()},
\code{\link{bring_api}()},
\code{\link{db_download}()},
\code{\link{db_upload}()},
\code{\link{export_plot}()},
\code{\link{export_results}()},
\code{\link{h2o_predict_API}()},
\code{\link{h2o_predict_MOJO}()},
\code{\link{h2o_predict_binary}()},
\code{\link{h2o_predict_model}()},
\code{\link{h2o_selectmodel}()},
\code{\link{haveInternet}()},
\code{\link{image_metadata}()},
\code{\link{importxlsx}()},
\code{\link{ip_data}()},
\code{\link{json2vector}()},
\code{\link{listfiles}()},
\code{\link{mail_send}()},
\code{\link{msplit}()},
\code{\link{myip}()},
\code{\link{quiet}()},
\code{\link{read.file}()},
\code{\link{statusbar}()},
\code{\link{tic}()},
\code{\link{try_require}()},
\code{\link{updateLares}()},
\code{\link{zerovar}()}

Other Credentials: 
\code{\link{db_download}()},
\code{\link{db_upload}()},
\code{\link{get_tweets}()},
\code{\link{mail_send}()},
\code{\link{queryDB}()},
\code{\link{queryGA}()},
\code{\link{slackSend}()},
\code{\link{stocks_file}()},
\code{\link{stocks_report}()}
}
\concept{Credentials}
\concept{Tools}
