% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/onehotencoding.R
\name{ohe_commas}
\alias{ohe_commas}
\title{One Hot Encoding for a Vector with Comma Separated Values}
\usage{
ohe_commas(df, ..., sep = ",", noval = "NoVal", remove = FALSE)
}
\arguments{
\item{df}{Dataframe. May contain one or more columns with comma separated
values which will be separated as one hot encoding}

\item{...}{Variables. Which variables to split into new columns?}

\item{sep}{Character. Which regular expression separates the elements?}

\item{noval}{Character. No value text}

\item{remove}{Boolean. Remove original variables?}
}
\value{
data.frame on which all features are numerical by nature or
transformed with one hot encoding.
}
\description{
This function lets the user do one hot encoding on a variable with 
comma separated values
}
\examples{
df <- data.frame(id = c(1:5),
                 x = c("AA, D", "AA,B", "B,  D", "A,D,B", NA),
                 z = c("AA+BB+AA", "AA", "BB,  AA", NA, "BB+AA"))
ohe_commas(df, x, remove = TRUE)
ohe_commas(df, z, sep = "\\\\+")
ohe_commas(df, x, z)
}
\seealso{
Other Data Wrangling: 
\code{\link{balance_data}()},
\code{\link{categ_reducer}()},
\code{\link{cleanText}()},
\code{\link{date_cuts}()},
\code{\link{date_feats}()},
\code{\link{formatNum}()},
\code{\link{holidays}()},
\code{\link{impute}()},
\code{\link{left}()},
\code{\link{normalize}()},
\code{\link{numericalonly}()},
\code{\link{ohse}()},
\code{\link{removenacols}()},
\code{\link{removenarows}()},
\code{\link{replaceall}()},
\code{\link{textFeats}()},
\code{\link{textTokenizer}()},
\code{\link{vector2text}()},
\code{\link{year_month}()},
\code{\link{year_week}()}

Other One Hot Encoding: 
\code{\link{date_feats}()},
\code{\link{holidays}()},
\code{\link{ohse}()}
}
\concept{Data Wrangling}
\concept{One Hot Encoding}
