% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tune.spLearner.R
\name{tune.spLearner,spLearner-method}
\alias{tune.spLearner,spLearner-method}
\alias{tune.spLearner}
\title{Optimize spLearner by fine-tuning parameters and running feature selection}
\usage{
\S4method{tune.spLearner}{spLearner}(
  object,
  num.trees = 85,
  blocking,
  discrete_ps,
  rdesc = mlr::makeResampleDesc("CV", iters = 2L),
  inner = mlr::makeResampleDesc("Holdout"),
  maxit = 20,
  xg.model_Params,
  xg.skip = FALSE,
  parallel = "multicore",
  hzn_depth = FALSE,
  ...
)
}
\arguments{
\item{object}{spLearner object (unoptimized),}

\item{num.trees}{number of random forest trees,}

\item{blocking}{blocking columns,}

\item{discrete_ps}{settings for random forest,}

\item{rdesc}{resampling method for fine-tuning,}

\item{inner}{resampling method for feature selection,}

\item{maxit}{maximum number of iterations for feature selection,}

\item{xg.model_Params}{xgboost parameter set,}

\item{xg.skip}{logical, should the tuning of the XGboost should be skipped?}

\item{parallel}{Initiate parallel processing,}

\item{hzn_depth}{specify whether horizon depth available in the training dataframe,}

\item{...}{other arguments that can be passed on to \code{mlr::makeStackedLearner},}
}
\value{
optimized object of type spLearner
}
\description{
Optimize spLearner by fine-tuning parameters and running feature selection
}
\note{
Currently requires that two base learners are \code{regr.ranger} and
\code{regr.xgboost}, and that there are at least 3 base learners in total.
Fine-tuning and feature selection can be quite computational
and it is highly recommended to start with smaller subsets of data and then measure
processing time. The function \code{mlr::makeFeatSelWrapper} can result in
errors if the covariates have a low variance or follow a zero-inflated distribution.
Reducing the number of features via feature selection and fine-tuning of the
Random Forest mtry and XGboost parameters, however, can result in
significantly higher prediction speed and accuracy.
}
\examples{
\donttest{
library(mlr)
library(ParamHelpers)
library(geoR)
library(xgboost)
library(kernlab)
library(ranger)
library(glmnet)
library(raster)
demo(meuse, echo=FALSE)
## Regression:
sl = c("regr.ranger", "regr.xgboost", "regr.ksvm", "regr.cvglmnet")
m <- train.spLearner(meuse["lead"], covariates=meuse.grid[,c("dist","ffreq")],
      lambda=0, parallel=FALSE, SL.library=sl)
summary(m@spModel$learner.model$super.model$learner.model)
## Optimize model:
t <- try( m0 <- tune.spLearner(m, xg.skip = TRUE, parallel=FALSE), silent=TRUE)
if(!class(t) == "try-error") summary(m0@spModel$learner.model$super.model$learner.model)
}
}
\author{
\href{https://opengeohub.org/people/tom-hengl}{Tom Hengl}
}
