% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plugincvc.R
\name{plugincvc}
\alias{plugincvc}
\title{Plug-in moment covariance estimator}
\usage{
plugincvc(xi, obswin = NULL, setcov_boundarythresh = NULL)
}
\arguments{
\item{xi}{An observation of a RACS of interest as a full binary map (as an \code{im} object) or as the foreground set (as an \code{owin} object).
In the latter case the observation window, \code{obswin}, must be supplied.}

\item{obswin}{If \code{xi} is an \code{owin} object then \code{obswin} is an
\code{owin} object that specifies the observation window.}

\item{setcov_boundarythresh}{To avoid instabilities caused by dividing by very small quantities, if the set covariance of the observation window
is smaller than \code{setcov_boundarythresh}, then the covariance is given a value of NA.}
}
\value{
A \pkg{SpatStat} \code{im} object containing the estimated covariance.
}
\description{
This function computes the plug-in moment covariance estimate of a stationary RACS from a binary map.
For a stationary RACS, \eqn{\Xi}, the covariance
for a vector \eqn{v} is the probability of two points separated by a vector \eqn{v} are covered by \eqn{\Xi}
\deqn{C(v) = P(\{x,x+v\}\subseteq \Xi).}{C(v) = P({x, x+ v} in Xi).}
}
\details{
The plug-in moment covariance estimator is (Serra, 1982)
\deqn{ \hat{C}(v) = \frac{\gamma_{W\cap X}(v)}{\gamma_W(v)}}{ C(v) = gammaWX(v) / gammaW(v) }
where \eqn{\gamma_{W}(v)}{gammaW(v)} is the set covariance of the observation window \eqn{W}
and \eqn{\gamma_{W\cap X}(v)}{gammaWX(v)} is the set covariance of the foreground within \eqn{W}.
\code{plugincvc} uses Fourier transforms to calculate the set covariance (using the \code{\link[spatstat]{setcov}} of the foreground and observation window.
Vectors with small \eqn{\gamma_W(v)}{ gammaW(v) } are eliminated using \code{setcov_boundarythresh}
as division by small values is numerically unstable.
}
\examples{
xi <- as.im(heather$coarse, na.replace = 0)
covar <- plugincvc(xi)
}
\references{
Serra, J.P. (1982) \emph{Image Analysis and Mathematical Morphology}. London; New York: Academic Press.
}
\author{
{Kassel Liam Hingee}
}
\keyword{nonparametric}
\keyword{spatial}
