% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taill.R
\name{taill}
\alias{taill}
\title{Return Last Rows of a Data Frame with Value Labels Visible}
\usage{
taill(data, n = 6L)
}
\arguments{
\item{data}{a data.frame.}

\item{n}{the number of consecutive rows at the end / bottom of the data.frame
to return.}
}
\value{
a data.frame.
}
\description{
\code{taill} accepts a labelr value-labeled data.frame and returns the last n
value-labeled rows of that data.frame
}
\details{
Whereas \code{utils::tail} returns the last n rows of a data.frame, \code{taill} does
the same thing, substituting value labels for values wherever the former exist.
See also \code{headl} and \code{somel}.
}
\examples{
# make toy demographic (gender, raceth, etc.) data set
set.seed(555)
df <- make_demo_data(n = 1000) # another labelr:: function
# let's add variable VALUE labels for variable "raceth"
df <- add_val_labs(df,
  vars = "raceth", vals = c(1:7),
  labs = c("White", "Black", "Hispanic", "Asian", "AIAN", "Multi", "Other"),
  max.unique.vals = 50
)

# let's add variable VALUE labels for variable "gender"
# note that, if we are labeling a single variable, we can use add_val1()
# distinction between add_val1() and add_val_labs() will become more meaningful
# when we get to our Likert example
df <- add_val1(
  data = df, gender, vals = c(0, 1, 2),
  labs = c("M", "F", "O"), max.unique.vals = 50
)

tail(df) # utils::tail
taill(df) # same, but with value labels in place of values
}
