% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kzp2.R
\name{kzp2}
\alias{kzp2}
\alias{kzp2.summary}
\alias{smooth.kzp2}
\title{Check Images' Motion Scales with 2D KZ Periodogram Signals}
\usage{
kzp2(x, m = dim(x), k = 1, ...)

smooth.kzp2(rpg, dpct = 0.01, w = dim(rpg), k = 1)

kzp2.summary(spg, rg.x, rg.y = rg.x)
}
\arguments{
\item{x}{Data array of 2D wave field. Missing values are allowed.
Limited to 2D arrays for current version.}

\item{m}{The window size for a regular Fourier transform.
Default value is set to data array size.}

\item{k}{The number of iterations for the KZFT. Default is 1.}

\item{...}{Arguments to be passed to methods.
\itemize{
 \item    \code{w : } Smoothing window size. Defaults to data array size.
 \item    \code{k : } The number of iteration times of KZFT
 \item    \code{n : } The sampling frequency rate as a multiplication 
                of the Fourier frequencies
 \item    \code{p : } The distance between two successive intervals as 
                a percentage of the total length of the data series
}}

\item{rpg}{Array of raw 2D periodogram. Usually it is part of output of \code{kzp2}.}

\item{dpct}{A pre-specified percentage of total variation.
Default value is 1\%.}

\item{w}{Smoothing window size. Defaults to data array dimension.}

\item{spg}{Array of smoothed 2D periodogram. It could be output of \code{summary.kzp2}.}

\item{rg.x}{Frequency range for x direction. Defaults to c(0, 0.5).}

\item{rg.y}{Frequency range for y direction. 
Defaults to the same value of the range for x direction.}
}
\value{
Returned value of function \code{kzp2} is a data list of 
		periodogram information, including data array \emph{kzp2d} for 2D 
		periodogram values, and two frequency vectors, \emph{freq.x} and  
		\emph{freq.y} for \emph{x} and \emph{y} direction, respectively.

			\code{smooth.kzp2} only outputs the array of smoothed values.
		
			\code{kzp2.summary} returns a data list for suggested wave 
		paramenters, including frequecy and direction values.
}
\description{
Functions used to reveal directional and scale information
with 2D KZ periodograms for spatial motions covered by heavy noises. 

   One can get 2D raw periodogram with function \code{kzp2}, and smooth the
2D periodogram with function \code{smooth.kzp2}. 

   Function \code{summary.kzp2} can help to summarize direction and frequency 
 information from smoothed 2D KZ periodogram.
}
\details{
KZ 2D raw spectrum is calculated based on \code{kz.ft}.
		The smoothing method is an extension of \code{kzft::smooth.kzp}.
		See introduction of DZ method in \code{kzft::smooth.kzp} for more 
		information.
}
\examples{
dx <- 100				# x range
dy <- 120				# y range
b <- expand.grid(x=1:dx, y=1:dy)
q1 <- pi/6; f1 <- 0.2;
b$v1 <- sin(f1*2*pi*(b$x*cos(q1)+b$y*sin(q1))+100*runif(1))
q2 <- pi/4; f2 <- 0.08;
b$v2 <- sin(f2*2*pi*(b$x*cos(q2)+b$y*sin(q2))+100*runif(1))
a <- array(0,c(dx,dy))
a[as.matrix(b[,1:2])] <- b$v1 + 1.5*b$v2
a <- a + 10*matrix(rnorm(dx*dy,0,1),ncol=dy)

rp <- kzp2(a)			# raw 2D spectrum

fy <- rp$freq.y; fx <- rp$freq.x; rp <- rp$kzp2d

# smoothing 2D spectrum 2 times
sp <- smooth.kzp2(rp,0.01,k=2)	

par(mfrow=c(2,1), cex=0.5)
persp(x=fx, y=fy, z=rp, expand =0.5,
	main = "Raw 2D KZ Periodogram", ltheta=40, shade=0.75,
	theta=-30, phi=15, zlab="",xlab="x", ylab="y",
	ticktype="detailed", col="lightblue")

persp(x=fx, y=fy, z=sp, expand =0.5,
	main = "Smoothed 2D KZ Periodogram", ltheta=40, shade=0.75,
	theta=-30, phi=25, zlab="",xlab="x", ylab="y",
	ticktype="detailed", col="lightblue")
par(mfrow=c(1,1), cex=1)

kzp2.summary(sp)		# direction & frequency

}
\seealso{
\code{\link{kzpdr}}, \code{\link{kzpdr.eval}}, \code{\link{kzpdr.spikes}}
}
\concept{
Kolmogorov-Zurbenko periodogram

2-dimensional periodogram

2D periodogram
}
\keyword{2D-periodogram}

