\name{random.functions}
\alias{dbern}
\alias{rbigamma}
\alias{rbilogistic}
\alias{dcorbern}
\alias{dmixnorm}
\alias{dnorm.norm.gamma}
\alias{rbern}
\alias{rejective.sampling}
\alias{rnorm.ar}
\alias{rmixnorm}
\alias{rnorm.norm.gamma}
\alias{rdoublexp}
\alias{ddoublexp}
\alias{qdoublexp}
\alias{pdoublexp}
\alias{rbidoublexp}

\title{
Random Functions
}
\description{
Generate samples from random variables.
}
\usage{

dbern(x, prob, log = FALSE)

dcorbern(x, p, a, log = FALSE)

dmixnorm(x, mix.p, sd1, sd2, log = FALSE)

dnorm.norm.gamma(x, p, same.distr = FALSE, log = FALSE)

rbern(n, prob, generalized = FALSE)

rbigamma(n, shape.1, shape.2, rate.1, rate.2, rho)

rbilogistic(n, loc.1, loc.2, scale.1, scale.2, rho) 

rejective.sampling(N, n, pik)

rnorm.ar(n, sd, rho)

rnorm.norm.gamma(n, mu.0, lambda, alpha, beta)

rmixnorm (n, mix.p, mu1, mu2, sd1, sd2)

rdoublexp(n, location=0, scale=1) 
ddoublexp(x, location=0, scale=1) 
qdoublexp(p, location=0, scale=1) 
pdoublexp(q, location=0, scale=1) 

rbidoublexp(n, loc.1, loc.2, scale.1, scale.2, rho) 

}
%- maybe also 'usage' for other objects documented here.
\arguments{

  \item{q}{
tbdx
}
  \item{location}{
tbdx
}
  \item{scale}{
tbdx
}


  \item{x}{
tbdx
}
  \item{prob}{
tbdprob
}
  \item{log}{
tbdlog
}

  \item{p}{
tbdp
}
  \item{a}{
tbda
}

  \item{mix.p}{
tbdmix.p
}
  \item{sd1}{
tbdsd1
}
  \item{sd2}{
tbdsd2
}

  \item{same.distr}{
tbdsame.distr
}

  \item{n}{
tbdn
}
  \item{generalized}{
tbdgeneralized
}

  \item{N}{
tbdN
}
  \item{pik}{
tbdpik
}

  \item{mu}{
tbdmu
}
  \item{mu1}{
tbdmu
}
  \item{mu2}{
tbdmu
}
  \item{sd}{
tbdsd
}
  \item{alpha}{
tbdalpha
}

  \item{mu.0}{
tbdmu.0
}
  \item{lambda}{
tbdlambda
}
  \item{beta}{
tbdbeta
}
  \item{loc.1}{
tbdbeta
}
  \item{loc.2}{
tbdbeta
}
  \item{scale.1}{
tbdbeta
}
  \item{scale.2}{
tbdbeta
}
  \item{rate.1}{
tbdbeta
}
  \item{rate.2}{
tbdbeta
}
  \item{shape.1}{
tbdbeta
}
  \item{shape.2}{
tbdbeta
}
  \item{rho}{
tbdbeta
}
}
\details{
rbern generates Bernoulli random variables.\cr
rbilogistic generates a bivariate logistic distribution for correlation coefficient 0.5, or [-0.271, 0.478]. \cr
In the former case it is generated by calling \code{rbilogis}, part of the VGAM package; in the latter case it is generated via the AMH copular.\cr
rnorm.ar simulate autoregressive normal random variables, correlation is rho^d between x_1 and x_(1+d)
}

\examples{

set.seed(1)
rbern(n=10, p=1/2)
rbern(n=2, p=c(.999,.001))

\dontrun{
tmp=replicate(1e4, rnorm.cor(10, 1, .81))
round(cor(t(tmp)),2)
}
}
