% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/stats_lasso.R
\name{knockoff.stat.lasso_difference}
\alias{knockoff.stat.lasso_difference}
\alias{knockoff.stat.lasso_signed_max}
\title{Knockoff filter lasso statistics}
\usage{
knockoff.stat.lasso_difference(X, X_ko, y, method = c("glmnet", "lars"), ...)

knockoff.stat.lasso_signed_max(X, X_ko, y, method = c("glmnet", "lars"), ...)
}
\arguments{
\item{X}{original design matrix}

\item{X_ko}{knockoff matrix}

\item{y}{response vector}

\item{method}{either 'glmnet' or 'lars' (see Details)}

\item{...}{additional arguments specific to 'glmnet' or 'lars' (see Details)}
}
\value{
The statistic \eqn{W}
}
\description{
Computes the difference statistic
  \deqn{W_j = Z_j - \tilde{Z}_j}
or the signed maximum statistic
  \deqn{W_j = \max(Z_j, \tilde{Z}_j) \cdot \mathrm{sgn}(Z_j - \tilde{Z}_j),}
where \eqn{Z_j} and \eqn{\tilde{Z}_j} are the maximum values of
\eqn{\lambda} at which the jth variable and its knockoff, respectively,
enter the lasso model.
}
\details{
This function can use either the \code{glmnet} or the \code{lars}
package to compute the lasso path. The \code{lars} package computes the lasso
path exactly, while \code{glmnet} approximates it using a fine grid of
\eqn{\lambda}'s. For large matrics, \code{glmnet} can be much faster than
\code{lars}. By default, \code{glmnet} is used.

If \code{method} is set to \code{'glmnet'}, the \code{nlambda} parameter can
be used to control the granularity of the grid of \eqn{\lambda}'s. The
default value of \code{nlambda} is \code{5*p}, where \code{p} is the number
of columns of \code{X}.
}

