% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spin.R
\name{spin}
\alias{spin}
\title{Spin goat's hair into wool}
\usage{
spin(hair, knit = TRUE, report = TRUE, text = NULL, envir = parent.frame(), 
    format = c("Rmd", "Rnw", "Rhtml", "Rtex", "Rrst"), doc = "^#+'[ ]?", 
    inline = "^[{][{](.+)[}][}][ ]*$", comment = c("^[# ]*/[*]", "^.*[*]/ *$"), 
    precious = !knit && is.null(text))
}
\arguments{
\item{hair}{Path to the R script. The script must be encoded in UTF-8 if it
contains multibyte characters.}

\item{knit}{Logical; whether to compile the document after conversion.}

\item{report}{Logical; whether to generate a report for \file{Rmd},
\file{Rnw} and \file{Rtex} output. Ignored if \code{knit = FALSE}.}

\item{text}{A character vector of code, as an alternative way to provide the
R source. If \code{text} is not \code{NULL}, \code{hair} will be ignored.}

\item{envir}{Environment for \code{\link{knit}()} to evaluate the code.}

\item{format}{Character; the output format. The default is R Markdown.}

\item{doc}{A regular expression to identify the documentation lines; by
default it follows the roxygen convention, but it can be customized, e.g.
if you want to use \code{##} to denote documentation, you can use
\code{'^##\\\\s*'}.}

\item{inline}{A regular expression to identify inline R expressions; by
default, code of the form \code{\{\{code\}\}} on its own line is treated as
an inline expression.}

\item{comment}{A pair of regular expressions for the start and end delimiters
of comments; the lines between a start and an end delimiter will be
ignored. By default, the delimiters are \verb{/*} at the beginning of a
line, and \verb{*/} at the end, following the convention of C comments.}

\item{precious}{logical: whether intermediate files (e.g., \code{.Rmd} files
when \code{format} is \code{"Rmd"}) should be preserved. The default is
\code{FALSE} if \code{knit} is \code{TRUE} and the input is a file.}
}
\value{
If \code{text} is \code{NULL}, the path of the final output document,
  otherwise the content of the output.
}
\description{
This function takes a specially formatted R script and converts it to a
literate programming document. By default normal text (documentation) should
be written after the roxygen comment (\code{#'}) and code chunk options are
written after \code{#+} or \code{#-} or \code{# ----} or any of these
combinations replacing \code{#} with \code{--}.
}
\details{
Obviously the goat's hair is the original R script, and the wool is the
literate programming document (ready to be knitted).
}
\note{
If the output format is Rnw and no document class is specified in
  roxygen comments, this function will automatically add the \code{article}
  class to the LaTeX document so that it is complete and can be compiled. You
  can always specify the document class and other LaTeX settings in roxygen
  comments manually.

  When the output format is Rmd, it is compiled to HTML via
  \code{\link{knit2html}()}, which uses R Markdown v1 instead of v2. If you
  want to use the latter, you should call
  \code{rmarkdown::\link[rmarkdown]{render}()} instead.
}
\references{
\url{https://yihui.name/knitr/demo/stitch/}
}
\seealso{
\code{\link{stitch}} (feed a template with an R script)
}
\author{
Yihui Xie, with the original idea from Richard FitzJohn (who named it
  as \code{sowsear()} which meant to make a silk purse out of a sow's ear)
}
