% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinn.R
\name{kinn.predict}
\alias{kinn.predict}
\title{Predicts response vector using kinn model}
\usage{
kinn.predict(g, data, verbose = F)
}
\arguments{
\item{g}{kinn model object}

\item{data}{dataframe which holds preictors}

\item{verbose}{printing detalied log}
}
\value{
predicton response vector
}
\description{
Predicts response vector using kinn model
}
\examples{
library(kinn)
library(caret)
x<-runif(100,min = 0,max=10)
e<-rnorm(100)
y<-2*x+3+e
df<-data.frame(x,y)
inTrain <- createDataPartition(y = df$y, p = 0.7, list = FALSE)
train <-df[inTrain, ]
test <- df[-inTrain, ]
model=kinn.train("y~x",train)
yhat=kinn.predict(model,test)
}

