\name{kinerrmin}
\Rdversion{1.1}
\alias{kinerrmin}
\title{
Calculate the minimum error to assume in order to pass the variance test
}
\description{
This function uses \code{\link{optimize}} in order to iteratively find the
smallest relative error still resulting in passing the chi-squared test
as defined in the FOCUS kinetics report from 2006.
}
\usage{
kinerrmin(kinfits, kinmodel = "SFO", alpha = 0.05)
}
\arguments{
  \item{kinfits}{
The list of kinetic model(s) from which to select. Usually this will have been
generated by \code{\link{kinfit}}.
}
  \item{kinmodel}{
The kinetic model to be checked. Should be one of the names of the kinetic models used for generating \code{kinfits}.
}
  \item{alpha}{
The confidence level chosen for the chi-squared test.
}
}
\value{
The relative error, expressed as a fraction.
}
\references{ 
  FOCUS (2006) \dQuote{Guidance Document on Estimating Persistence and
  Degradation Kinetics from Environmental Fate Studies on Pesticides in EU
  Registration} Report of the FOCUS Work Group on Degradation Kinetics,
  EC Document Reference Sanco/10058/2005 version 2.0, 434 pp,
  \url{http://focus.jrc.ec.europa.eu/dk} 
}
\author{ Johannes Ranke }
\examples{
data(FOCUS_2006_A)
kinfits <- kinfit(FOCUS_2006_A)
kinerrmin(kinfits)
}
\keyword{ manip }
