% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_to_excel_formula.R
\name{convert_to_excel_formula}
\alias{convert_to_excel_formula}
\title{Convert character to Excel formula}
\usage{
convert_to_excel_formula(vector = NULL)
}
\arguments{
\item{vector}{a character vector}
}
\value{
the output will be a character vector formatted as an Excel
formula. For example, if an element in the input vector was \code{".500"},
this element will be converted to \code{=".500"}, which will show up as
".500" in Excel, rather than as "0.5"
}
\description{
Convert elements of a character vector to Excel formulas to preserve
the character (string) format when opened in an Excel file.
}
\examples{
\dontrun{
# compare the two csv files below
# example 1
dt <- data.table::data.table(a = ".500")
data.table::fwrite(dt, "example1.csv") # the csv will show "0.5"
# example 2
dt <- data.table::data.table(a = convert_to_excel_formula(".500"))
data.table::fwrite(dt, "example2.csv") # the csv will show ".500"
}
}
