% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repeated_measures_anova.R
\name{repeated_measures_anova}
\alias{repeated_measures_anova}
\title{Repeated-Measures ANVOA}
\usage{
repeated_measures_anova(
  data = NULL,
  p_col_name = NULL,
  measure_vars = NULL,
  histograms = TRUE,
  round_w = 2,
  round_epsilon = 2,
  round_df_model = 2,
  round_df_error = 2,
  round_f = 2,
  round_ges = 2
)
}
\arguments{
\item{data}{a data object (a data frame or a data.table)}

\item{p_col_name}{name of the column identifying participants}

\item{measure_vars}{names of the columns containing repeated measures
(within-subjects variables)}

\item{histograms}{logical. If \code{histograms = TRUE}, histograms
of the repeated measures will be plotted. If \code{histograms = FALSE},
no histograms will be plotted.}

\item{round_w}{number of decimal places to which to round
W statistic from Mauchly's test (default = 2)}

\item{round_epsilon}{number of decimal places to which to round
the epsilon statistic from Greenhouse-Geisser or Huynh-Feldt
correction (default = 2)}

\item{round_df_model}{number of decimal places to which to round
the corrected degrees of freedom for model (default = 2)}

\item{round_df_error}{number of decimal places to which to round
the corrected degrees of freedom for error (default = 2)}

\item{round_f}{number of decimal places to which to round
the F statistic (default = 2)}

\item{round_ges}{number of decimal places to which to round
generalized eta-squared (default = 2)}
}
\description{
Conduct a repeated-measures analysis of variance (ANOVA).
This analysis will be appropriate for within-subjects experimental design.
}
\details{
The following package(s) must be installed prior to running the function:
Package 'ez' v4.4-0 (or possibly a higher version) by
Michael A Lawrence (2016),
\url{https://cran.r-project.org/package=ez}
}
\examples{
\dontrun{
repeated_measures_anova(
  data = mtcars, p_col_name = "cyl", measure_vars = c("wt", "qsec"))
}
}
