% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/theme_kim.R
\name{theme_kim}
\alias{theme_kim}
\title{Theme Kim}
\usage{
theme_kim(
  legend_position = "none",
  base_size = 20,
  axis_tick_font_size = 20,
  axis_title_font_size = 24,
  y_axis_title_vjust = 0.85,
  axis_title_margin_size = 24,
  cap_axis_lines = TRUE
)
}
\arguments{
\item{legend_position}{position of the legend (default = "none")}

\item{base_size}{base font size}

\item{axis_tick_font_size}{font size for axis tick marks}

\item{axis_title_font_size}{font size for axis title}

\item{y_axis_title_vjust}{position of the y axis title (default = 0.85).
If default is used, \code{y_axis_title_vjust = 0.85}, the y axis title
will be positioned at 85\% of the way up from the bottom of the plot.}

\item{axis_title_margin_size}{size of the margin between axis title
and the axis line}

\item{cap_axis_lines}{logical. Should the axis lines be capped at the
outer tick marks? (default = TRUE)}
}
\description{
A custom ggplot theme
}
\examples{
\donttest{
prep(ggplot2)
ggplot2::ggplot(mtcars, aes(x = cyl, y = mpg)) + geom_point() + theme_kim()
}
}
