% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/row-id.R
\name{compare_ids}
\alias{compare_ids}
\title{Compare IDs between data frames}
\usage{
compare_ids(before, after, .id = ".id")
}
\arguments{
\item{before}{Data frame before transformation.}

\item{after}{Data frame after transformation.}

\item{.id}{Column name for IDs (default: ".id").}
}
\value{
A list with:
\itemize{
\item \code{lost}: IDs present in \code{before} but not \code{after}
\item \code{gained}: IDs present in \code{after} but not \code{before}
\item \code{preserved}: IDs present in both
}
}
\description{
Compares IDs between two data frames to detect lost rows.
}
\examples{
df1 <- add_id(data.frame(x = 1:5))
df2 <- df1[1:3, ]
compare_ids(df1, df2)

}
